USE hahn;

-- responsible: yelmurat@
-- ticket: https://st.yandex-team.ru/PODB-20918

$version = 'v1_0';

$use_fast_dump = %%USE_FAST_DUMP%%;

$yt_table_path = '%%YT_TABLE_PATH%%';
$output_path = $yt_table_path || '_' || $version;

PRAGMA library("default_library.sql", 'arc://analytics/unifav/dashboard/default_library.sql?rev=%%REVISION%%');
IMPORT `default_library` SYMBOLS 
	$get_cards
    ;


$start_date = "2021-01-01";
$end_date = SELECT CAST(CurrentUtcDate() as String);


INSERT INTO $output_path WITH TRUNCATE
SELECT
    card_meta_info_origin,
    card_dashboard_type,
    card_service_created_at_date,
    COUNT(*) AS cnt
FROM $get_cards($start_date, $end_date, $use_fast_dump)
GROUP BY
    card_meta_info_origin,
    card_dashboard_type,
    card_service_created_at_date
ORDER BY
    card_meta_info_origin,
    card_dashboard_type,
    card_service_created_at_date
;

SELECT $output_path AS target_path;
