USE hahn;
-- PRAGMA yt.PoolTrees = "physical";
-- PRAGMA yt.TentativePoolTrees = "cloud";

-- responsible: yelmurat@
-- ticket: https://st.yandex-team.ru/PODB-21237

$version = 'v1_6';
$start_date = "2021-01-01";
$end_date = SELECT CAST(CurrentUtcDate() as String);

$use_fast_dump = %%USE_FAST_DUMP%%;

$yt_table_path = '%%YT_TABLE_PATH%%';
$output_path = $yt_table_path || '_' || $version;

PRAGMA library("default_library.sql", 'arc://analytics/unifav/dashboard/default_library.sql?rev=%%REVISION%%');
IMPORT `default_library` SYMBOLS
	$get_cards
    ;

$cards = 
SELECT
    card_service_created_at_date,
    
    card_content_source_type,
    
    card_meta_info_type,
    card_meta_info_origin,
    
    card_page_meta_info_type,
    
    card_origin_client_name,
    card_origin_client_ui,
    card_origin_action,
    card_origin_ui,

    is_private,
    is_banned,
    is_card_domain_market,

    card_dashboard_type,

    COUNT(*) AS cnt
FROM $get_cards($start_date, $end_date, $use_fast_dump)
GROUP BY 
    card_service_created_at_date,
    
    card_content_source_type,
    
    card_meta_info_type,
    card_meta_info_origin,
    
    card_page_meta_info_type,
    
    card_origin_client_name,
    card_origin_client_ui,
    card_origin_action,
    card_origin_ui,

    is_private,
    is_banned,
    is_card_domain_market,

    card_dashboard_type
;

INSERT INTO $output_path WITH TRUNCATE
SELECT *
FROM $cards;

SELECT $output_path AS target_path;
