USE hahn;
-- PRAGMA yt.PoolTrees = "physical";
-- PRAGMA yt.TentativePoolTrees = "cloud";

-- responsible: yelmurat@
-- ticket: https://st.yandex-team.ru/PODB-21224

$version = 'v1_2';
$start_date = "2021-01-01";
$end_date = SELECT CAST(CurrentUtcDate() as String);

$use_fast_dump = %%USE_FAST_DUMP%%;

$yt_table_path = '%%YT_TABLE_PATH%%';
$output_path = $yt_table_path || '_' || $version;

PRAGMA library("default_library.sql", 'arc://analytics/unifav/dashboard/default_library.sql?rev=%%REVISION%%');
IMPORT `default_library` SYMBOLS $get_cards;

-- end head
$cards = PROCESS $get_cards($start_date, $end_date, $use_fast_dump);

INSERT INTO $output_path WITH TRUNCATE
SELECT
    card_service_created_at_date,
    card_dashboard_type,
    is_card_domain_market,
    COUNT(*) AS cnt,
    COUNT(card_owner_id) AS cnt_not_null_user_id,
    COUNT(card_id) AS cnt_not_null_card_id,
    COUNT(DISTINCT card_owner_id) AS cntd_user_id,
    COUNT(DISTINCT card_id) AS cntd_card_id
FROM $cards
GROUP BY
    card_service_created_at_date,
    card_dashboard_type,
    is_card_domain_market
;

SELECT $output_path AS target_path;
