#!/usr/bin/env python2.7
# coding: utf8

import argparse
import datetime
import json
import os
# import re

# from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    # get_cluster,
    # get_driver,
    YqlRunner
    # get_date,
    # apply_replacements,
)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-o', '--output', type=argparse.FileType('w'), required=True)
    return parser.parse_args()

query = """
use cocainesrw;

SELECT
    eventname,
    page_id,
    count(*) as cnt,
    toUnixTimestamp(now()) - 60 AS fielddate
FROM cocaine_logs.strm_gogol_log
PREWHERE timestamp BETWEEN toUnixTimestamp(now()) - 360 and toUnixTimestamp(now()) - 60
where has(['BroadcastAdReceived', 'BroadcastAdInit', 'OriginalBroadcastAdStart', 'OriginalBroadcastAdEnd', 'ReceivedMetadata'], eventName) and not isNull(
    multiIf(
        data_currentStream_url like '%partner_id=451940%',
        '451940',
        data_currentStream_url like '%partner_id=451944%',
        '451944',
        data_currentStream_url like '%partner_id=453404%',
        '453404',
        data_currentStream_url like '%partner_id=453546%',
        '453546',
        null
    )
)
group by eventName as eventname, multiIf(
        data_currentStream_url like '%partner_id=451940%',
        '451940',
        data_currentStream_url like '%partner_id=451944%',
        '451944',
        data_currentStream_url like '%partner_id=453404%',
        '453404',
        data_currentStream_url like '%partner_id=453546%',
        '453546',
        null
    ) as page_id
"""


def main():
    args = parse_args()

    yc = YqlClient(token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(yc, title="MMA-3647 | YQL")
    yc.config.db = None
    res = yr.run(
        query,
        query_type="CLICKHOUSE"
    )
    # print str(res)
    fr = []
    stat_data = []
    for elem in str(res).split('\n'):
        if '<' in elem:
            continue
        elem_data = [x.strip() for x in elem.strip().split('\t')]
        if not fr:
            fr = elem_data
            continue
        res = dict(zip(fr, elem_data))
        res['fielddate'] = datetime.datetime.fromtimestamp(int(res['fielddate'])).strftime('%Y-%m-%d %H:%M:00')
        stat_data.append(res)
    # print stat_data
    args.output.write(json.dumps(stat_data))
    args.output.close()


if __name__ == '__main__':
    main()
