#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
import sys


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--type', default='android')
    parser.add_argument('--input', required=True)
    parser.add_argument('--output', default='output.tsv')
    args = parser.parse_args()

    if args.type in {'android', 'touch'}:
        appendage = '\tANDROID\tRU\n'
    elif args.type == 'desktop':
        appendage = '\tDESKTOP\tRU\n'
    elif args.type == 'ios':
        appendage = '\tIOS\tRU\n'
    else:
        sys.stderr.write('"{}" is an invalid device type.'.format(args.type))
        sys.exit(1)

    with open(args.input, 'r') as f_in, open(args.output, 'w') as f_out:
        for line in f_in:
            f_out.write(line.strip() + appendage)


if __name__ == "__main__":
    main()
