#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import pyperclip
import json
from collections import OrderedDict


country_dict = OrderedDict({
    'RU': 2000,
    'BY': 480,
    'UA': 400,
    'TR': 400,
    'KZ': 400,
    'UZ': 400,
    # world
    'AZ': 200,
    'AM': 200,
    'GE': 200,
    'IL': 200,
    'KG': 200,
    'LV': 200,
    'LT': 200,
    'MD': 200,
    'TJ': 200,
    'TM': 200,
    'EE': 200,
})


def main():
    google = []
    yandex = []
    for country in country_dict:
        for platform in ['desktop', 'touch']:
            yandex.append(
                {
                    'country': country,
                    'count': int(country_dict[country] * 300 * 0.25),
                    'service': 'web',
                    'platform': platform
                }
            )
            yandex.append(
                {
                    'country': country,
                    'count': int(country_dict[country] * 300 * 0.5),
                    'service': 'vid',
                    'platform': platform
                }
            )
            yandex.append(
                {
                    'country': country,
                    'count': int(400 * 300 * 0.25),
                    'service': 'vid',
                    'classifiers': 'isFilm',
                    'platform': platform
                }
            )
            yandex.append(
                {
                    'country': country,
                    'count': int(400 * 300 * 0.25),
                    'service': 'vid',
                    'classifiers': 'isPorn',
                    'platform': platform
                }
            )
            yandex.append(
                {
                    'country': country,
                    'count': int(400 * 300 * 0.25),
                    'service': 'vid',
                    'classifiers': 'isSerial',
                    'platform': platform
                }
            )
            google.append(
                {
                    'country': country,
                    'count': int(country_dict[country] * 300 * 0.25),
                    'service': 'youtube',
                    'platform': platform
                }
            )
    json.dump(google, open('google.json', 'w'), indent=2)
    json.dump(yandex, open('yandex.json', 'w'), indent=2)


if __name__ == "__main__":
    main()
