#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import os
import argparse
from nile.api.v1 import (
    clusters
)
import json


def main():

    parser = argparse.ArgumentParser()
    parser.add_argument('--table_list')
    parser.add_argument('--output', default='output.json')
    args = parser.parse_args()

    hahn = clusters.yt.Hahn(token=os.environ['YT_TOKEN'])

    with open(args.table_list) as f:
        table_list = json.load(f)

    result = []

    for table in table_list:
        result.extend(
            [x.to_dict() for x in hahn.read(table)]
        )

    with open(args.output, 'w') as f:
        json.dump(result, f, indent=2, sort_keys=True)


if __name__ == "__main__":
    main()
