#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import json
import time
import argparse
import requests
import smtplib
import shutil
from email.mime.text import MIMEText
os.environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'


def send_mail(msg, addressees):
    msg = MIMEText(msg)
    msg['Subject'] = 'Suspicious pool'
    msg['From'] = 'pool-watch@yandex-team.ru'
    msg['To'] = ','.join(addressees)
    s = smtplib.SMTP('localhost')
    s.sendmail(msg['From'], addressees, msg.as_string())
    s.quit()


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('input')
    parser.add_argument('output')
    parser.add_argument('--token', required=True)
    parser.add_argument('--threshold', type=int, default=100)
    parser.add_argument(
        '--email', nargs='+', default=['ensuetina@yandex-team.ru']
    )
    args = parser.parse_args()

    print('Started')

    headers = {'Authorization': 'OAuth {}'.format(args.token)}

    pools = json.load(open(args.input))

    if not pools:
        shutil.copy(args.input, args.output)
        sys.exit(0)

    pool_id = pools[0]['poolId']

    j = requests.get(
        'https://toloka.yandex.ru/api/v1/pools/{}'.format(pool_id),
        headers=headers, verify=False
    ).json()
    cost = j['reward_per_assignment']

    operation = requests.post(
        'https://toloka.yandex.ru/api/staging/analytics-2/',
        json=[
            {
                'subject': 'POOL',
                'subject_id': pool_id,
                'name': 'estimated_assignments_count'
            }
        ],
        headers=headers, verify=False
    ).json()

    for t in range(5):
        time.sleep((t + 1) * 30)
        j2 = requests.get(
            'https://toloka.yandex.ru/api/v1/operations/{}'.format(
                operation['id']
            ),
            headers=headers, verify=False
        ).json()
        if j2['status'] == u'SUCCESS':
            break

    if j2['status'] == u'SUCCESS':
        ass_count = j2['details']['value'][0]['result']['value']
        print('Assignments count is {}'.format(ass_count))
        print('Cost per assignment is {}'.format(cost))
        est_cost = cost * ass_count
        print('Estimated cost of pool: {}'.format(est_cost))
        if est_cost >= args.threshold:
            print('The threshold of {} has been passed'.format(args.threshold))
            print('Sending email to {}...'.format(args.email))
            send_mail(
                'Estimated cost of pool {} is {}.\n Link to pool: {}'.format(
                    pool_id,
                    est_cost,
                    'https://toloka.yandex.ru/requester/pool/{}'.format(
                        pool_id
                    )
                ), args.email
            )
    else:
        print('Couldn\'t fetch data from API. Details: {}'.format(
            json.dumps(j2), indent=2
        ))

    shutil.copy(args.input, args.output)


if __name__ == "__main__":
    main()
