#-*-coding: utf8 -*-

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf
from datetime import datetime

import nile
import re
import uatraits
import json
import urllib
import urlparse
import argparse
from pytils import date_range
import math


def parse_us(groups):
    import libra

    for key, recs in groups:
        uid = key.key

        try:
            s = libra.ParseSession(recs, './blockstat.dict')
        except Exception as e:
            continue

        for r in s:
            if r.IsA('TTouchYandexVideoPortalRequest'):
                ui = 'touch video'
            elif r.IsA('TYandexVideoMordaRequest'):
                ui = 'desktop video'
            else:
                continue

            #ts = str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
            ts = r.Timestamp

            tvt = 0
            lvt = 0

            for bl in r.GetMainBlocks():
                result = bl.GetMainResult()
                if not result.IsA("TVideoResult"):
                    continue

                url = str(result.Url)
                pos = result.Position

                duration = r.FindVideoDurationInfo(result)
                if (duration):
                    dt = min(duration.PlayingDuration, duration.Duration)
                else:
                    dt = 0

                heartbeat = r.FindVideoHeartbeat(result, 'ANY')
                if (heartbeat):
                    ht = heartbeat.Ticks
                else:
                    ht = 0

                res_tvt = max(dt, ht)
                clicks = 0

                for cl in bl.GetClicks():
                    clicks += 1

                yield Record(
                    uid=uid,
                    ui=ui,
                    ts=ts,
                    url=url,
                    pos=pos,
                    shows=1,
                    clicks=clicks,
                    tvt=res_tvt
                )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date_from')
    parser.add_argument('--date_to')
    parser.add_argument('--output_table')
    parser.add_argument('--token')
    args = parser.parse_args()

    cluster = clusters.yt.Hahn(token=args.token)

    for d in date_range(args.date_from, args.date_to):
        job = cluster.job()

        us = job.table('user_sessions/pub/search/daily/{}/clean'.format(d))

        reqs = us.groupby('key').sort('subkey').reduce(
            parse_us,
            files=[
                nile.files.RemoteFile(
                    'statbox/statbox-dict-last/blockstat.dict'
                ),
                nile.files.RemoteFile(
                    'statbox/resources/libra.so'
                )
            ],
            memory_limit=4000
        ).put(
            args.output_table, append=True
        )

        job.run()


if __name__ == '__main__':
    main()
