#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    Record
)
import json


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--tsv_in_dups')
    parser.add_argument('--tsv_in')
    parser.add_argument('--tsv_out')
    parser.add_argument('--json_out')
    parser.add_argument('--token')
    args = parser.parse_args()

    dct = {}
    with codecs.open(args.tsv_in_dups, 'r', 'utf8') as f:
        for line in f:
            tabs = line.strip().split('\t')
            dct[tabs[0]] = 'https://{}'.format(tabs[1])

    with codecs.open(args.tsv_in, 'r', 'utf8') as i, \
            codecs.open(args.tsv_out, 'w', 'utf8') as o:
        for line in i:
            tabs = line.strip().split('\t')
            if tabs[0] not in dct:
                continue
            o.write(
                '\t'.join([dct[tabs[0]]] + tabs[1:]) + '\n'
            )

    json.dump(dct, open(args.json_out, 'w'), indent=2)


if __name__ == "__main__":
    main()
