#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
import datetime
import requests
import time
import gzip
import StringIO
import json
from collections import defaultdict, Counter
requests.packages.urllib3.disable_warnings()


def check_serpset(id_):
    retries = 0
    j = None
    while not j and retries < 3:
        try:
            j = requests.get(
                'https://metrics-calculation.qloud.yandex-team.ru'
                '/api/qex/metric-observation?regional=RU&evaluation=VIDEO'
                '&left-serp-set={s}&right-serp-set={s}'
                '&metric=judged-dups-metric'.format(s=id_),
                verify=False, headers=headers
            ).json()
        except Exception as e:
            retries += 1
            print('oops: {}'.format(e))
            time.sleep(5)
    for check in j[0]['checks']:
        if check['leftState'] != 'PASSED' or check['rightState'] != 'PASSED':
            return False
    return True


def get_date(id_):
    retries = 0
    j = None
    while not j and retries < 3:
        try:
            j = requests.get(
                'http://metrics.yandex-team.ru/services/api/serpset/info'
                '?id={s}'.format(s=id_),
                verify=False, headers=headers
            ).json()
        except Exception as e:
            retries += 1
            print('oops: {}'.format(e))
            time.sleep(5)
    return datetime.datetime.strptime(
        j['date'].split('T')[0], '%Y-%m-%d'
    ).date()


def get_serps(id_):
    retries = 0
    j = None
    while not j and retries <= 3:
        print('getting serpset {}'.format(id_))
        try:
            j = requests.get(
                'https://metrics-calculation.qloud.yandex-team.ru/api/json/'
                '{}?regional=RU&evaluation=VIDEO&aspect=availability_mobile'
                '&absolute=false&serpset-filter=onlySearchResult'
                '&requirement=COMPONENT.thumbadd'
                '&requirement=COMPONENT.text.videoDudation'
                '&requirement=COMPONENT.text.videoDuration'.format(id_),
                verify=False, headers=headers
            )
        except Exception as e:
            print('oops: {}'.format(e))
            retries += 1
            time.sleep(5)
    return json.load(gzip.GzipFile(fileobj=StringIO.StringIO(j.content)))


def parse_date(s):
    return datetime.datetime.strptime(s, '%Y-%m-%d').date()


download_ids = {
    'v': '7066',
    'k': '7966',
    'v_nd': '7956',
    'k_nd': '7452',
}


def get_serpsets(date1, date2, download_id):
    req = requests.get(
        'https://metrics.yandex-team.ru/services/api/serpset/list/RU/VIDEO/'
        '?from={}T00:00:00.000&to={}T00:00:00.000'
        '&cronSerpDownloadId={}'.format(
            date1, date2, download_id
        ), verify=False, headers=headers
    )
    try:
        return req.json()
    except:
        import pdb; pdb.set_trace()


headers = {}


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('date')
    parser.add_argument('--metrics_token')
    parser.add_argument('--output_v')
    parser.add_argument('--output_v_nd')
    parser.add_argument('--output_k')
    parser.add_argument('--output_k_nd')
    args = parser.parse_args()

    headers['Authorization'] = 'OAuth {}'.format(args.metrics_token)

    args.date = parse_date(args.date)
    date1 = args.date - datetime.timedelta(days=2)
    date2 = args.date + datetime.timedelta(days=2)

    serpsets = {}
    for d_name in download_ids:
        serpsets[d_name] = [
            serpset_id for serpset_id in get_serpsets(
                date1, date2, download_ids[d_name]
            )
        ]
        serpsets[d_name] = [
            x for x in serpsets[d_name]
            if get_date(x) == args.date
        ]
        filename = getattr(args, 'output_{}'.format(d_name))
        if len(serpsets[d_name]) > 0:
            serpset = get_serps(serpsets[d_name][0])
            json.dump(
                serpset, open(filename, 'w'), indent=2
            )
        else:
            json.dump(
                {}, open(filename, 'w'), indent=2
            )


if __name__ == "__main__":
    main()
