from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf

import nile
import datetime
import uatraits, json
import urllib, urlparse
import sys
import os

#cluster = clusters.yt.Hahn(pool = 'search-research_ensuetina',
#                       ).env(templates=dict(job_root='home/videolog/ensuetina/YABRO_PUSH'),
#                                              parallel_operations_limit=10)
cluster = clusters.yt.Hahn(pool = 'constructor-platform',
                       ).env(yt_spec_defaults=dict(
                                        pool_trees=["physical"],
                                         #tentative_pool_trees=["cloud"]
                                        use_default_tentative_pool_trees = True
                                     ),templates=dict(job_root='home/videolog/ensuetina/YABRO_PUSH'),
                       parallel_operations_limit=10)

def parser(records):
    for record in records:
        cookiei = record.icookie
        date = record.date

        clicked = 0
        shown = 0
        received = 0
        closed = 0
        other = 0

        action = record.path
        push_id = record.push_id
        push = str(push_id).split('.')[0]

        if push == '':
            push = 'empty push'

        if action == "clicked":
            clicked = 1
        elif action == "shown":
            shown = 1
        elif action == "received":
            received = 1
        elif action == "closed":
            closed = 1
        else:
            other = 1

        yield Record(cookiei=cookiei,fielddate=date,action=action,push_id=push_id,push_name=push,
                     clicked=clicked,shown=shown,
                     received=received,closed=closed,other=other)

        yield Record(cookiei=cookiei,fielddate=date,action=action,push_id=push_id,push_name='_total_',
                     clicked=clicked,shown=shown,received=received,closed=closed,other=other)

        if push.startswith('tv_online'):
            yield Record(cookiei=cookiei,fielddate=date,action=action,push_id=push_id,push_name='TV ONLINE',
                         clicked=clicked,shown=shown,received=received,closed=closed,other=other)
            if push.endswith('_stitle'):
                yield Record(cookiei=cookiei,fielddate=date,action=action,push_id=push_id,push_name='TV ONLINE_STITLE',
                         clicked=clicked,shown=shown,received=received,closed=closed,other=other)

date_format = '%Y-%m-%d'
date = datetime.datetime.today() + datetime.timedelta(days=-1)
d = date.strftime(date_format)

print d

job = cluster.job()

redir = job.table('logs/redir-log/1d/' + d)

t = redir.qb2(
    log = 'redir-log',
    fields = [
        'yandexuid','date','path','normal_path','parsed_log_line','normal_vars','timestamp',
        se.log_field('icookie'),
        'pid','cid',
        se.custom('push_id', lambda x: x.get('push_id') if x else '-','normal_vars')
    ],
    filters = [
        sf.or_(sf.equals('cid','73559'),sf.equals('cid',73559)),
        sf.or_(sf.equals('pid', '457'),sf.equals('pid', 457)),
        sf.not_(sf.equals('push_id','-'))
    ],
    mode = 'yamr_lines',
).map(parser).put('$job_root/parsed_log')

t.project('push_name','clicked','shown','received','closed','other','fielddate',
          push_id=ne.const('_total_')
         ).groupby('fielddate','push_name','push_id'
                  ).aggregate(clicked=na.sum('clicked'),
                              shown=na.sum('shown'),
                              received=na.sum('received'),
                              closed=na.sum('closed'),
                              other=na.sum('other')
                            ).put('$job_root/report')

job.run()

client = ns.StatfaceClient(
        proxy = 'upload.stat.yandex-team.ru',
                token = os.environ['STAT_TOKEN']
                    )

ns.StatfaceReport().path('Video.All/yabropush') \
                   .scale('daily') \
                   .client(client) \
                   .remote_publish(proxy='hahn',
                                   table_path='//home/videolog/ensuetina/YABRO_PUSH/report',
                                   async_mode=False,
                                   upload_config=False)
