# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '15850'


    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        q = str(r.Query)

        if r.HasTestID(c):
            slot = c
        else:
            continue

        sp = r.SearchPropsValues
        spF = sp.get('UPPER.EntitySearch.Log')
        if not '|film_list_Q' in str(spF):
            continue
#            yield Record(uid,'',q + '\t' + str(spF))

        isP = 0

        for bl in r.GetBSBlocks():
            p = bl.Path
            if 'parallel/object-answer/upper' in p:
                isP = 1
                break

        if isP == 0:
            continue

        d600 = 0
        d300 = 0
        d180 = 0
        d120 = 0

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            dw = int(cl.DwellTime)
            if dw > 600:
                d600 += 1
            if dw > 300:
                d300 += 1
            if dw > 180:
                d180 += 1
            if dw > 120:
                d120 += 1

        yield Record(uid,'',q + '\t' + str(spF) + '\t' + str(d600) + '\t' + str(d300) + '\t' + str(d180) + '\t' + str(d120))


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['05']
    for d in dd:
        src = 'user_sessions/201509' + d

        dt0 = 'ensuetina/CARUSEL_LONG_CLICKS/long_clicks'
        dt1 = 'ensuetina/CARUSEL_LONG_CLICKS/clicks'
        dt2 = 'ensuetina/CARUSEL_LONG_CLICKS/video'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt0,
#                            dstTables = [dt0,dt1,dt2],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
