# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re, random, urlparse

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '17995'
    e = '17996'


    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        if r.HasTestID(c):
            TI = 0
            slot = 'control ' + c
        elif r.HasTestID(e):
            TI = 1
            slot = 'exp ' + e
        else:
            continue

        yield Record(uid,'',slot + '\t' + ts, tableIndex = TI) # all reqs

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            url = str(cl.Url)
            host = urlparse.urlparse(url).netloc
            if 'kinopoisk.ru' in host:
                yield Record(uid,'',slot + '\t' + ts + '\t' + p + '\t' + host, tableIndex = TI + 2) # kp clicks


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['1031','1101','1102','1103','1104','1105']
    for d in dd:
        src = 'user_sessions/2015' + d

        dt0 = 'ensuetina/KP_TRAFFIC/all_reqs_control'
        dt1 = 'ensuetina/KP_TRAFFIC/all_reqs_exp'
        dt2 = 'ensuetina/KP_TRAFFIC/kp_control'
        dt3 = 'ensuetina/KP_TRAFFIC/kp_exp'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1,dt2,dt3],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
