# -*- coding: UTF-8 -*-
from nile import (
    clusters,
    Record,
    filters as nf,
    aggregators as na
)
import nile
import uatraits, libra

from datetime import datetime

import urlparse

def Reduce(groups):
    c = '19710'
    e = '19711'

    detector = uatraits.detector('/usr/share/uatraits/browser.xml')

    for key, records in groups:
        uid = key.key
        if uid[0] != 'y':
            continue
        try:
            uid_date = uid[-10:]
        except:
            continue

        if int(uid_date) > 1450731600:
            age = 'NEW'
        else:
            age = 'OLD'

        uid_ts = str(datetime.fromtimestamp(float(uid_date)).isoformat()).split('T')[0]

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'Touch'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

            if r.HasTestID(c):
                slot = 'control ' + c
                TI = 0
            elif r.HasTestID(e):
                slot = 'exp ' + e
                TI = 1
            else:
                continue

            SM = '-'
            spv = r.SearchPropsValues
            for k in spv:
                if 'REPORT.smartbanner' in k:
                    SM = k + '=' + str(spv[k])
                    break

            ref = str(r.Referer).split('?')[0]
            ua = str(r.UserAgent)
            d = detector.detect(ua)

            BR = ''
            BV = ''
            OS = ''
            OSV = ''

            if 'OSName' in d:
                OS = d['OSName']
            if 'OSVersion' in d:
                OSV = d['OSVersion']
            if 'BrowserName' in d:
                BR = d['BrowserName']
            if 'BrowserVersion' in d:
                BV = d['BrowserVersion']

            smClick = 0
            for cl in r.GetClicks():
                p = cl.ConvertedPath
                #if 'smartbanner/' in p and not '/close' in p:
                if 'snippet/bno' in p:
                    smClick = 1
                    break

            yield Record(uid=uid,age=age,ts=ts,slot=slot,OS=OS,OSV=OSV,BR=BR,BV=BV,smClick=smClick,SM=SM)
            #yield Record(uid,'',slot + '\t' + uid_ts + '\t' + ts + '\t' + age + '\t' + str(csp) + '\t' + str(clck) + '\t' + str(isCl) + '\t' + ref + '\t' + ua, tableIndex = TI)

def collect_reqs(groups):
    c = '19710'
    e = '19711'
    for key, records in groups:
        uid = key.key
        if uid[0] != 'y':
            continue
        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'Touch'
            else:
                continue

            if r.HasTestID(c):
                slot = 'control ' + c
            elif r.HasTestID(e):
                slot = 'exp ' + e
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

            clk = 0
            smsh = 0
            for bl in r.GetBSBlocks():
                p = bl.Path
                if 'smartbanner/' in p:
                    smsh = 1
                    break
            SM = 0
            spv = r.SearchPropsValues
            for k in spv:
                if 'REPORT.smartbanner' in k:
                    #SM = k + '=' + str(spv[k])
                    SM = 1
                    break


            yield Record(uid=uid,ts=ts,slot=slot,SM=SM,smsh=smsh)


class test_prod:
    def __init__(self,pref):
        self.pref = pref
    def __call__(self,groups):
        for key, records in groups:
            uid = key.key
            if uid[0] != 'y':
                continue
            try:
                session = libra.ParseSession(records, 'blockstat.dict')
            except:
                continue

            for r in session:
                if r.IsA('TTouchYandexWebRequest'):
                    ui = 'Touch'
                else:
                    continue

                ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

                smClick = 0
                for cl in r.GetClicks():
                    p = cl.ConvertedPath
                    if self.pref in p and not '/close' in p:
                        smClick = 1
                        break

                if smClick == 1:
                    yield Record(uid=uid,ts=ts,smClick=smClick)


cluster = clusters.YT(proxy="hahn.yt.yandex.net").env(
                                                        job_root=('home/search-research/ensuetina/SMARTBANNER_OFF/major_test')
                                                     )

# считаем клики по смартбаннеру за 22 декабря
job = cluster.job()
us = job.table('user_sessions/pub/search/daily/2015-12-22/clean')

reqs = us.groupby('key').sort('subkey').reduce(collect_reqs,files=[nile.files.LocalFile('blockstat.dict'),nile.files.LocalFile('libra.so')]).put('$job_root/one_day_reqs')

rr = reqs.groupby('uid','slot').aggregate(SM=na.max('SM'),smsh=na.max('smsh')).put('$job_root/aggr_reqs')

c = rr.filter(nf.equals('slot','control 19710')).put('$job_root/all_control')
e = rr.filter(nf.equals('slot','exp 19711')).put('$job_root/all_exp')

#c = job.table('$job_root/all_control')
#e = job.table('$job_root/all_exp')

c.filter(nf.equals('SM',0)).put('$job_root/SM0_control')
c.filter(nf.equals('SM',1)).put('$job_root/SM1_control')

#c.filter(nf.equals('sm',0)).put('$job_root/sm0_control')
#c.filter(nf.equals('sm',1)).put('$job_root/sm1_control')

e.filter(nf.equals('SM',0)).put('$job_root/SM0_exp')
e.filter(nf.equals('SM',1)).put('$job_root/SM1_exp')

#e.filter(nf.equals('sm',0)).put('$job_root/sm0_exp')
#e.filter(nf.equals('sm',1)).put('$job_root/sm1_exp')

#ac = c.groupby('uid','slot','ts').aggregate(freq = na.count()).put('$job_root/aggr_control_20151222')
#ae = e.groupby('uid','slot','ts').aggregate(freq = na.count()).put('$job_root/aggr_exp_20151222')

#clicks = us.groupby('key').sort('subkey').reduce(test_prod('smartbanner/'),files=[nile.files.LocalFile('blockstat.dict'),nile.files.LocalFile('libra.so')]).put('$job_root/smartbanner_clicks')
#clicks.groupby('uid').aggregate(sm_clicks=na.count()).project('uid').put('$job_root/UIDS/smartbanner_uids')

job.run()

# считаем запросы на серпе со 2 по 16 марта
dates = ['2016-03-01']#nile.api.path.DateRange('2016-03-03', '2016-03-16')
for date in dates:
    continue

    job = cluster.job().env(date=date)

    us = job.table('user_sessions/pub/search/daily/$date/clean')

    reqs = us.groupby('key').sort('subkey').reduce(collect_reqs,files=[nile.files.LocalFile('blockstat.dict'),nile.files.LocalFile('libra.so')]).put('$job_root/all_reqs',append=True)

    job.run()

#with open('found_uids_1222.txt') as f:
#    uids = f.read().replace('\r','').split('\n')

#recs = []
#for u in uids:
#    recs.append(Record(uid=u))

#cluster.write('$job_root/2/2/found_uids_1222',recs)

# оставляем запросы только кликавших смартбаннер пользователей
# считаем сколько кликавших пользователей видели на серпе со 2 по 16 марта
#job = cluster.job()

#uids = job.table('$job_root/bno_clicked_uids')
#reqs = job.table('$job_root/all_reqs')

#t1 = reqs.groupby('ts').aggregate(count=na.count()).put('$job_root/dates')

#j = reqs.join(uids,by='uid',type='inner').put('$job_root/bno_reqs_joined')
#j.groupby('uid').aggregate(reqs=na.count()).put('$job_root/bno_reqs_joined_uids')

#wl = job.table('$job_root/1/wl_exp')

#j = wl.join(uids,by='uid',type='inner').put('$job_root/joined_found_1222')
#jf = j.filter(nf.custom(lambda x: int(x.replace('-','')) > 20151222, 'subkey')).put('$job_root/joined_found_1222_filtered')

#j.groupby('uid').aggregate(hits=na.count()).put('$job_root/joined_found_1222_uids')
#jf.groupby('uid').aggregate(hits=na.count()).put('$job_root/joined_found_1222_filtered_uids')


#job.run()



