# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


class Reduce:
    def __init__(self, control, exp):
        self.c = control
        self.e = exp

    def __call__(self, key, recs):
        uid = key
        if uid[0] != 'y':
            return

        try:
            uid_date = uid[-10:]
        except:
            return

        if int(uid_date) > 1453842000:
            age = 'NEW'
        else:
            age = 'OLD'

        uid_ts = str(datetime.fromtimestamp(float(uid_date)).isoformat()).split('T')[0]

        try:
            s = libra.ParseSession(recs, './blockstat.dict')
        except:
            return

        c = '20435'
        e = '20437'

        for r in s:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'Touch'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

            if r.HasTestID(c):
                slot = 'control ' + c
                TI = 0
            elif r.HasTestID(e):
                slot = 'exp ' + e
                TI = 1
            else:
                continue

            if uid.replace('y','') in self.c or uid.replace('y','') in self.e:
                csp = 1
            else:
                csp = 0

            ref = str(r.Referer).split('?')[0]
            ua = str(r.UserAgent)

            clck = 0
            for cl in r.GetClicks():
                clck += 1

            isCl = 0
            for bl in r.GetMainBlocks():
                m = bl.GetMainResult()
                if m.IsA('TDirectResult'):
                    continue

                for cl in bl.GetClicks():
                    isCl = 1
                    break

            yield Record(uid,'',slot + '\t' + uid_ts + '\t' + ts + '\t' + age + '\t' + str(csp) + '\t' + str(clck) + '\t' + str(isCl) + '\t' + ref + '\t' + ua, tableIndex = TI)



def aggr(key,recs):
    yield Record(key,'','')


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dt0 = 'ensuetina/TOUCH_HTTPS/full_exp/control'
    dt1 = 'ensuetina/TOUCH_HTTPS/full_exp/exp'

    MapReduce.runReduce(aggr,
                        srcTable = dt0,
                        dstTable = dt0 + '_uids',
                        sortMode = True
                       )
    MapReduce.runReduce(aggr,
                        srcTable = dt1,
                        dstTable = dt1 + '_uids',
                        sortMode = True
                       )


if __name__ == '__main__':
    main()
