# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '20628'
    e = '20629'

    f = -1

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        q = r.Query
        url = str(r.FullRequest)
        ref = str(r.Referer)

        if r.HasTestID(c):
            slot = 'control ' + c
            TI = 0
        elif r.HasTestID(e):
            slot = 'exp ' + e
            TI = 1
        else:
            continue

        if 'callback' in url:
#            yield Record(uid,'',slot + '\t' + ts + '\t' + q + '\t' + url + '\t' + ref, tableIndex = TI + 4)
#            if q == '':
            isFooter = 0
            for bl in r.GetBSBlocks():
                p = bl.Path
                if 'web/item/title' in p:
                    isFooter = 1
                    break

            if isFooter == 1:
                continue

            bsbl = len(r.GetBSBlocks())
            ua = r.UserAgent

            yield Record(uid,'',r.ReqID + '\t' + slot + '\t' + ts + '\t' + q + '\t' + str(bsbl) + '\t' + url + '\t' + ref + '\t' + ua, tableIndex = TI)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20160205', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20160206):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt0 = 'ensuetina/PUSHBUNDLE/1/control_empty'
        dt1 = 'ensuetina/PUSHBUNDLE/1/exp_empty'
#        dt2 = 'ensuetina/PUSHBUNDLE/control_near'
#        dt3 = 'ensuetina/PUSHBUNDLE/exp_near'
#        dt4 = 'ensuetina/PUSHBUNDLE/control_callbacks'
#        dt5 = 'ensuetina/PUSHBUNDLE/exp_callbacks'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
