# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '21167'
    e1 = '21168'
    e2 = '21169'
    e3 = '21170'

    prev_t = -1
    nav_t = -1

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'desktop'
        else:
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        prev_t = r.Timestamp
        req_t = r.Timestamp

        if r.HasTestID(c):
            slot = 'control ' + c
        elif r.HasTestID(e1):
            slot = 'exp 5 tabs 4px ' + e1
        elif r.HasTestID(e2):
            slot = 'exp 5 tabs 5px ' + e2
        elif r.HasTestID(e3):
            slot = 'exp 7 tabs 4px ' + e3
        else:
            continue

        ref = r.Referer
        all_cl = 0
        page = r.PageNo

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            url = str(cl.Url)
            if 'yandex.ru' in url:
                Y = 'yandex'
            else:
                Y = 'not yandex'

            secs = cl.DelayAfterRequest
            dw = cl.DwellTimeOnService

            if 'serp/navig/' in p:
                nav_t = req_t + secs
                delta = nav_t - prev_t
            else:
                prev_t = req_t + secs
                delta = '-'

            yield Record(uid,'',ts + '\t' + slot + '\t' + str(page) + '\t' + url + '\t' + Y + '\t' + p + '\t' + str(delta) + '\t' + str(dw), tableIndex = 1)

        for bl in r.GetMainBlocks():
            m = bl.GetMainResult()
            if m.IsA('TDirectResult'):
                continue

            for cl in bl.GetClicks():
                all_cl += 1

        yield Record(uid,'',ts + '\t' + slot + '\t' + str(page) + '\t' + ref + '\t' + str(all_cl), tableIndex = 0)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20160301', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20160322):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt0 = 'ensuetina/TABBAR/reqs'
        dt1 = 'ensuetina/TABBAR/clicks'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
