# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c1 = '21911'
    e1 = '21912'

    c2 = '23358'
    e21 = '23359'
    e22 = '23360'
    e23 = '23361'

    for r in s:
        if r.IsA('TTouchYandexWebRequest'):
            ui = 'Touch'
        elif r.IsA('TPadYandexWebRequest'):
            ui = 'Tablet'
        elif r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        elif r.IsA('TMobileAppYandexWebRequest'):
            ui = 'APP'
        else:
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        ua = str(r.UserAgent)
        q = str(r.Query)

        if r.HasTestID(c1):
            slot = 'control ' + c1
            TI = 0
        elif r.HasTestID(e1):
            slot = 'exp ' + e1
            TI = 0
        elif r.HasTestID(c2):
            slot = 'control ' + c2
            TI = 1
        elif r.HasTestID(e21):
            slot = 'exp ' + e21
            TI = 1
        elif r.HasTestID(e22):
            slot = 'exp ' + e22
            TI = 1
        elif r.HasTestID(e23):
            slot = 'exp ' + e23
            TI = 1
        else:
            continue

        isBNO = 0
        isVideo = 0
        isOA = 0
        isImages = 0

        for bl in r.GetBSBlocks():
            p = bl.Path
            if 'snippet/bno' in p:
                isBNO = 1
            if 'snippet/video/' in p:
                isVideo = 1
            if 'snippet/images/' in p:
                isImages = 1
            if 'parallel/object-answer' in p:
                isOA = 1


        for cl in r.GetClicks():
            if cl.IsA('TClick'):
                notMisc = 1
            else:
                notMisc = 0

            if cl.IsA('TMiscResultClick'):
                misc = 1
            else:
                misc = 0

            p = cl.ConvertedPath
            vv = str(cl.GetVars())
            dw = cl.DwellTime
            secs = cl.DelayAfterRequest
            dw2 = cl.DwellTimeOnService
            yield Record(uid,'',ui + '\t' + slot + '\t' + ts + '\t' + q + '\t' + p + '\t' + vv + '\t' + str(dw) + '\t' + str(secs) + '\t' + str(dw2) + '\t' + str(isBNO) + '\t' + str(isVideo) + '\t' + str(isOA) + '\t' + str(isImages) + '\t' + str(notMisc) + '\t' + str(misc), tableIndex = 1)

#        for cl in r.GetMiscClicks():
#            p = cl.ConvertedPath
#            vv = str(cl.GetVars())
#            dw = cl.DwellTime
#            secs = cl.DelayAfterRequest
#            dw2 = cl.DwellTimeOnService
#            yield Record(uid,'',ui + '\t' + slot + '\t' + ts + '\t' + q + '\t' + p + '\t' + vv + '\t' + str(dw) + '\t' + str(secs) + '\t' + str(dw2) + '\t' + str(isBNO) + '\t' + str(isVideo) + '\t' + str(isOA) + '\t' + str(isImages), tableIndex = 0)

def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

#    cur_d1 = datetime.strptime('20160307', '%Y%m%d')
#    cur_d1 = cur_d1.date()

#    cur_d = str(cur_d1).replace('-','')
#    while int(cur_d)<int(20160308):

#        print cur_d

    dd = ['20160317']
    dd = ['20160409']
    dd = ['20160412']
    for d in dd:
        src = 'user_sessions/' + d

        dt0 = 'ensuetina/Constructor_EXP/2/clicks_desktop_dynamics_misc'
        dt1 = 'ensuetina/Constructor_EXP/2/clicks_desktop_dynamics_new_misc_flag'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )

if __name__ == '__main__':
    main()
