# -*- coding: UTF-8 -*-
from nile import (
    filters as nf,
    aggregators as na,
    extractors as ne
)
from nile.api.v1 import clusters
from nile.processing import Record
import nile

from qb2.api.v1 import extractors as se, filters as sf



cluster = clusters.yt.Hahn().env(templates = dict(
                                                        job_root = 'home/search-research/ensuetina/HTTPS_NEW_UIDS_2'
                                                )
                                                )

dates = ['2016-04-14','2016-04-15','2016-04-16','2016-04-17','2016-04-18','2016-04-19','2016-04-20']
for date in dates:
    job = cluster.job().env(default_mode='yamr_lines')

    redir = job.table('statbox/redir-log/' + date)

    t = redir.qb2(log='redir-log',
                  fields = ['date','dtype','uid','log_line'],
                  filters = [sf.defined('dtype','uid'),
                             sf.equals('dtype','jserror')
                            ]
                ).put('$job_root/jserrors', append=True)


    job.run()

job = cluster.job()

reqs = job.table('$job_root/reqs').groupby('uid','slot').aggregate(reqs=na.count()).project('slot','reqs',uid=ne.custom(lambda x: x.replace('y',''),'uid'))
errors = job.table('$job_root/jserrors')

reqs.join(errors,by='uid',type='inner').put('$job_root/joined_errors')

job.run()

