#-*-coding: utf8 -*-

from nile.api.v1 import (
    clusters,
    Record,
    filters as nf,
    aggregators as na,
    extractors as ne
)
from qb2.api.v1 import extractors as se, filters as sf
import nile
import uatraits, libra

import urlparse

def Reduce(groups):
    detector = uatraits.detector('/usr/share/uatraits/browser.xml')
    for key, records in groups:
        uid = key.key
        #if uid[0] != 'y':
        #    continue

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'TOUCH'
            elif r.IsA('TYandexWebRequest'):
                ui = 'DESKTOP'
            elif r.IsA('TPadYandexWebRequest'):
                ui = 'PAD'
            else:
                continue

            ua = str(r.UserAgent)
            d = detector.detect(ua)

            if 'BrowserName' in d:
                BR = d['BrowserName']
            else:
                BR = '-'

            if r.HasTestID('26380'):
                slot = 'control 26380'
            elif r.HasTestID('26381'):
                slot = 'exp 26381'
            else:
                continue

            reqid = r.ReqID

            yield Record(reqid=reqid,slot=slot,ui=ui,BR=BR)
            #break



cluster = clusters.yt.Hahn(pool='search-research_ensuetina')

dates = ['2016-06-18']
for date in dates:
    job = cluster.job().env(default_mode='yamr_lines')

    log = job.table('user_sessions/pub/search/daily/' + date + '/clean')
    redir = job.table('statbox/redir-log/' + date)

    result = redir.qb2(log='redir-log',
                        fields=['reqid', 'normal_path', 'normal_vars','date',
                                se.custom('yuid', lambda yandexuid: 'y' + yandexuid)
                                  ],
                           filters = [sf.defined('yuid')]
                          ).put('home/search-research/ensuetina/WEB3_EXP/redir_clicks')


    reqids = log.groupby('key').sort('subkey').reduce(Reduce,
                                                    files=[nile.files.LocalFile('blockstat.dict'),
                                                           nile.files.LocalFile('libra.so')],
                                                    memory_limit=2000).groupby('reqid',
                                                                               'slot',
                                                                               'ui',
                                                                               'BR'
                                                                              ).aggregate(freq=na.count()).project(ne.all(),
                                                                                                                   #neg_freq=ne.custom(lambda x: -1*x, 'freq')
                                                                                                                  ).sort('neg_freq').put('home/search-research/ensuetina/WEB3_EXP/reqids')

    uids = job.table('home/search-research/ensuetina/WEB3_EXP/uids')

    clicks = job.table('home/search-research/ensuetina/WEB3_EXP/redir_clicks')


    j = clicks.join(reqids,by='reqid',type='inner').put('home/search-research/ensuetina/WEB3_EXP/exp_clicks')

#    j = job.table('exp_clicks')
    j.groupby('slot','ui','BR','normal_path').aggregate(freq=na.count()).put('home/search-research/ensuetina/WEB3_EXP/aggr_exp')

    job.run()

