# -*- coding: UTF-8 -*-
from nile.api.v1 import (
    clusters,
    Record,
    filters as nf,
    aggregators as na,
    extractors as ne
)
import nile

from qb2.api.v1 import extractors as se, filters as sf
import uatraits, libra

from datetime import datetime

import urlparse

def Reduce(groups):
    c = '27268'
    e = '27269'

    detector = uatraits.detector('/usr/share/uatraits/browser.xml')

    for key, records in groups:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'touch'
            elif r.IsA('TYandexWebRequest'):
                ui = 'desktop'
            elif r.IsA('TPadYandexWebRequest'):
                ui = 'tablet'
            elif r.IsA('TMobileAppYandexWebRequest'):
                ui = 'app'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
            reqid = r.ReqID

            if r.HasTestID(c):
                slot = 'control ' + c
            elif r.HasTestID(e):
                slot = 'exp ' + e
            else:
                continue

            ua = str(r.UserAgent)
            d = detector.detect(ua)

            BR = str(d.get('BrowserName'))
            BV = str(d.get('BrowserVersion'))

            yield Record(yandexuid=uid.replace('y',''),ui=ui,slot=slot,ts=ts,reqid=reqid,BR=BR,BV=BV)


cluster = clusters.yt.Hahn(pool='search-research_ensuetina').env(templates = dict(job_root=('home/search-research/ensuetina/SCRIPTS_CACHE')))

job = cluster.job().env(default_mode='yamr_lines')

us = job.table('user_sessions/pub/search/daily/2016-07-25/clean')
redir = job.table('statbox/redir-log/2016-07-25')

reqs = us.groupby('key').sort('subkey').reduce(Reduce,
                                               files=[nile.files.LocalFile('/home/ensuetina/blockstat.dict'),
                                                      nile.files.LocalFile('/home/ensuetina/libra.so')
                                                     ]
                                              ).put('$job_root/reqs')

#reqs = job.table('$job_root/reqs')

#errors = redir.qb2(log = 'redir-log',
#                   fields = ['yandexuid','reqid','dtype','log_line'],
#                   filters = [sf.equals('dtype','jserror')]
#                  ).put('$job_root/errors')

errors = job.table('$job_root/errors')

uids = reqs.groupby('slot','yandexuid','BR').aggregate(reqs=na.count())

j = errors.join(uids,by='yandexuid',type='inner').put('$job_root/joined_errors')

j.groupby('slot','BR').aggregate(errors=na.count()).put('$job_root/slot_errors')

job.run()



