# -*- coding: UTF-8 -*-
from nile.api.v1 import (
    clusters,
    Record,
    filters as nf,
    aggregators as na,
    extractors as ne
)
import nile
import uatraits, libra

from datetime import datetime

import urlparse

def Reduce(groups):
    c = '28544'
    e = '28545'

    for key, records in groups:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'Touch'
            elif r.IsA('TYandexWebRequest'):
                ui = 'desktop'
            elif r.IsA('TPadYandexWebRequest'):
                ui = 'pad'
            elif r.IsA('TMobileAppYandexWebRequest'):
                ui = 'app'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

            if r.HasTestID(c):
                slot = 'control ' + c
                TI = 0
            elif r.HasTestID(e):
                slot = 'exp ' + e
                TI = 1
            else:
                continue

            for cl in r.GetClicks():
                p = cl.ConvertedPath
                if 'snippet/images' in p:
                    vv = str(cl.GetVars())
                    if cl.IsA('TMiscResultClick'):
                        misc = 1
                    else:
                        misc = 0

                    if 'dynamic_click' in vv:
                        dyn = 1
                    else:
                        dyn = 0

                    yield Record(uid=uid,ui=ui,slot=slot,p=p,vv=vv,misc=misc,dyn=dyn)



cluster = clusters.yt.Hahn(pool='search-research_ensuetina').env(templates=dict(
                                                        job_root=('home/search-research/ensuetina/IMG_SCROLL_EXP')
                                                     )
                                                    )

job = cluster.job()

us = job.table('user_sessions/pub/search/daily/2016-08-06/clean')

reqs = us.groupby('key').sort('subkey').reduce(Reduce,
                                               files=[nile.files.LocalFile('/home/ensuetina/blockstat.dict'),
                                                      nile.files.LocalFile('/home/ensuetina/libra.so')]).put('$job_root/clicks')

job.run()


