# -*- coding: UTF-8 -*-
from nile.api.v1 import (
    clusters,
    Record,
    filters as nf,
    aggregators as na,
    extractors as ne
)
import nile
import uatraits, libra

from datetime import datetime

import urlparse

def Reduce(groups):
    c = '29490'
    e = '29491'

    detector = uatraits.detector('/usr/share/uatraits/browser.xml')

    for key, records in groups:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TYandexWebRequest'):
                ui = 'desktop'
            elif r.IsA('TTouchYandexWebRequest'):
                ui = 'touch'
            elif r.IsA('TPadYandexWebRequest'):
                ui = 'pad'
            elif r.IsA('TMobileAppYandexWebRequest'):
                ui = 'app'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

            if r.HasTestID(c):
                slot = 'control ' + c
            elif r.HasTestID(e):
                slot = 'exp ' + e
            else:
                continue

            reqid = r.ReqID

            ua = str(r.UserAgent)

            d = detector.detect(ua)

            BR = str(d.get('BrowserName'))
            OS = str(d.get('OSFamily'))

            yield Record(uid=uid,ui=ui,slot=slot,ts=ts,reqid=reqid,BR=BR,OS=OS,ua=ua)


cluster = clusters.yt.Hahn(pool='search-research_ensuetina').env(templates = dict(job_root=('home/search-research/ensuetina/SEARCHAPP_PERL')))

job = cluster.job()

us = job.table('user_sessions/pub/search/daily/2016-08-11/clean')

reqs = us.groupby('key').sort('subkey').reduce(Reduce,
                                                     files=[nile.files.LocalFile('/home/ensuetina/blockstat.dict'),
                                                     nile.files.LocalFile('/home/ensuetina/libra.so')
                                                            ]
                                                     ).put('$job_root/reqs')

job.run()



