# -*- coding: UTF-8 -*-
from nile import (
    filters as nf,
    aggregators as na
)

from nile.processing import Record
from nile.api.v1 import clusters
import nile
import uatraits, libra

from datetime import datetime

import urlparse

def Reduce(groups,reqs,clck):

    c_7793 = '23890'
    e1_7793 = '23891'
    e2_7793 = '23968'

    c_7794 = '23894'
    e1_7794 = '23895'
    e2_7794 = '23901'

    c_7796 = '23902'
    e1_7796 = '23965'
    e2_7796 = '23966'

    c_7792 = '23889'
    e1_7792 = '23892'
    e2_7792 = '23893'

    paths = {}
    paths['7792'] = ['snippet/entity_search/object-badge/feedback']
    paths['7793'] = ['snippet/entity-fact/feedback','snippet/long_fact/feedback','snippet/suggest_fact/feedback']
    paths['7794'] = ['web/item/feedback']
    paths['7796'] = ['snippet/long_fact/feedback']

    for key, records in groups:
        uid = key.key
        if uid[0] != 'y':
            continue

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TYandexWebRequest'):
                ui = 'desktop'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
            reqid = r.ReqID
            q = str(r.Query)


#            if r.HasTestID(c_7793):
#                slot = '7793 control ' + c_7793
#                exp = '7793'
#            elif r.HasTestID(e1_7793):
#                slot = '7793 exp ' + e1_7793
#                exp = '7793'
#            elif r.HasTestID(e2_7793):
#                slot = '7793 exp ' + e2_7793
#                exp = '7793'

#            if r.HasTestID(c_7794):
#                slot = '7794 control ' + c_7794
#                exp = '7794'
#            elif r.HasTestID(e1_7794):
#                slot = '7794 exp ' + e1_7794
#                exp = '7794'
#            elif r.HasTestID(e2_7794):
#                slot = '7794 exp ' + e2_7794
#                exp = '7794'

            if r.HasTestID(c_7796):
                slot = '7796 control ' + c_7796
                exp = '7796'
            elif r.HasTestID(e1_7796):
                slot = '7796 exp ' + e1_7796
                exp = '7796'
            elif r.HasTestID(e2_7796):
                slot = '7796 exp ' + e2_7796
                exp = '7796'

#            if r.HasTestID(c_7792):
#                slot = '7792 control ' + c_7792
#                exp = '7792'
#            elif r.HasTestID(e1_7792):
#                slot = '7792 exp ' + e1_7792
#                exp = '7792'
#            elif r.HasTestID(e2_7792):
#                slot = '7792 exp ' + e2_7792
#                exp = '7792'

            else:
                continue

            ppp = []
            ppp_vv = []

            isfeedbacks = 0
            for bl in r.GetBSBlocks():
                p = bl.Path
                vv = str(bl.GetVars())
                for k in paths[exp]:
                    if k in p and 'fact-phone' in vv:
                        isfeedbacks = 1
                        if not p in ppp:
                            ppp.append(p)
                            ppp_vv.append(str(bl.GetVars()))

            for cl in r.GetClicks():
                p = cl.ConvertedPath
                vv = str(cl.GetVars())
                pp = cl.Path

                for k in paths[exp]:
                    if (k in pp or k in p) and 'fact-phone' in vv:
                        clck(Record(uid=uid,ttype='click',reqid=reqid,slot=slot,ts=ts,q=q,isfeedbacks=isfeedbacks,p=p,pp=pp,vv=str(cl.GetVars()),ppp=str(ppp),ppp_vv=str(ppp_vv)))

#            for tech in r.GetYandexTechEvents():
#                if not tech.IsA('TYandexTechEvent'):
#                    continue
#                p = tech.Path
#                for k in paths[exp]:
#                    if k in p:
#                        vv = tech.Vars
#                        clck(Record(uid=uid,ttype='tech',reqid=reqid,slot=slot,ts=ts,q=q,isfeedbacks=isfeedbacks,p=p,pp=pp,vv=str(vv),ppp=str(ppp),ppp_vv=str(ppp_vv)))

            if isfeedbacks == 1:
                reqs(Record(uid=uid,ttype='serp',reqid=reqid,slot=slot,ts=ts,q=q,ppp=str(ppp), ppp_vv=str(ppp_vv)))



def map_bs(lines):
    paths = ['snippet/entity-fact/feedback','snippet/long_fact/feedback','snippet/suggest_fact/feedback','snippet/entity_search/object-badge/feedback','web/item/feedback']
    for line in lines:
        blocks = line.blocks

        for path in paths:
            if path in blocks and 'modal' in blocks:
                yield Record(path=path,blocks=blocks)
                break



def map_redir(lines):
    exp = {}
    exp['7793'] = ['23890','23891','23968']
    exp['7794'] = ['23894','23895','23901']
    exp['7796'] = ['23902','23965','23966']
    exp['7792'] = ['23889','23892','23893']

    paths = {}
    paths['254.1979.296'] = 'snippet/entity-search/feedback'
    paths['254.1985.296'] = 'snippet/long_fact/feedback'
    paths['254.1090.296'] = 'snippet/suggest_fact/feedback'
    paths['254.1950.2080.296'] = 'snippet/entity_search/object-badge/feedback'
    paths['80.22.296'] = 'web/item/feedback'
    for line in lines:
        s = line
        l = s.value

        data = dict([d.split('=', 1) for d in l.split('\t') if '=' in d])

        if not 'path' in data or not 'vars' in data or not 'slots' in data:
            continue

        uid = str(data.get('yandexuid'))
        slots = str(data.get('slots'))
        path = str(data.get('path'))
        vv = str(data.get('vars'))

        isS = 0
        for k in exp:
            if isS == 1:
                break
            for sl in exp[k]:
                if sl in slots:
                    slot = sl
                    expNo = k
                    isS = 1
                    break

        if isS == 0:
            continue

        for k in paths:
            if k in path and '.2171' in path:
                conv_path = paths[k]
                yield Record(uid=uid,slot=slot,expNo=expNo,path=path,conv_path=conv_path,vv=vv,log_line=l)
                break



cluster = clusters.Plato().env(templates=dict(
                                            job_root='home/search-research/ensuetina/FEEDBACK_EXPS'
                                            ))

dates = ['04-26','04-25','04-24','04-23','04-22']
for date in dates:
    #continue
    job = cluster.job()

#    us = job.table('user_sessions/pub/search/daily/2016-' + date + '/clean')

    us = job.table('userdata/user_sessions/2016-' + date)

    sh, cl = us.groupby('key').sort('subkey').reduce(Reduce,files=[nile.files.LocalFile('/home/ensuetina/blockstat.dict'),
                                                              nile.files.LocalFile('/home/ensuetina/libra.so')])

    sh.put('$job_root/sh7796', append=True)
    cl.put('$job_root/cl7796', append=True)

#    redir = job.table('statbox/redir-log/2016-' + date)
#    t = redir.map(map_redir).put('$job_root/feedback_clicks_modals')
#    t.groupby('expNo').aggregate(clicks=na.count()).put('$job_root/aggr_modals')

#    bs = job.table('statbox/blockstat-log/2016-' + date)
#    t = bs.map(map_bs).put('$job_root/bsb')
#    t.groupby('path').aggregate(clicks=na.count()).put('$job_root/aggr_bsb')

    job.run()




