# -*- coding: UTF-8 -*-
from nile import (
    filters as nf,
    aggregators as na
)

from nile.processing import Record
from nile.api.v1 import clusters
import nile
import uatraits, libra

from datetime import datetime

import urlparse

def Reduce(groups,reqs92,reqs93,reqs94,reqs96,c92,c93,c94,c96):

    c_7793 = '23890'
    e1_7793 = '23891'
    e2_7793 = '23968'

    c_7794 = '23894'
    e1_7794 = '23895'
    e2_7794 = '23901'

    c_7796 = '23902'
    e1_7796 = '23965'
    e2_7796 = '23966'

    c_7792 = '23889'
    e1_7792 = '23892'
    e2_7792 = '23893'

    paths = {}
    paths['7792'] = ['snippet/entity_search/object-badge/feedback']
    paths['7793'] = ['snippet/entity-fact/feedback','snippet/long_fact/feedback','snippet/suggest_fact/feedback']
    paths['7794'] = ['web/item/feedback']
    paths['7796'] = ['snippet/long_fact/feedback']

    for key, records in groups:
        uid = key.key
        if uid[0] != 'y':
            continue

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TYandexWebRequest'):
                ui = 'desktop'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
            reqid = r.ReqID
            q = str(r.Query)

            slot = '?'

            if r.HasTestID(c_7796):
                slot = '7796 control ' + c_7796
                exp = '7796'
            elif r.HasTestID(e1_7796):
                slot = '7796 exp ' + e1_7796
                exp = '7796'
            elif r.HasTestID(e2_7796):
                slot = '7796 exp ' + e2_7796
                exp = '7796'

            if slot != '?': # 7796 slot
                ppp = []
                ppp_vv = []

                isfeedbacks = 0
                for bl in r.GetBSBlocks():
                    p = bl.Path
                    vv = str(bl.GetVars())
                    for k in paths[exp]:
                        if k in p and 'fact-phone' in vv:
                            isfeedbacks = 1
                            if not p in ppp:
                                ppp.append(p)
                                ppp_vv.append(str(bl.GetVars()))

                for cl in r.GetClicks():
                    p = cl.ConvertedPath
                    vv = str(cl.GetVars())
                    pp = cl.Path

                    for k in paths[exp]:
                        if (k in pp or k in p) and 'fact-phone' in vv:
                            c96(Record(uid=uid,ttype='click',reqid=reqid,slot=slot,ts=ts,q=q,isfeedbacks=isfeedbacks,p=p,pp=pp,vv=str(cl.GetVars()),ppp=str(ppp),ppp_vv=str(ppp_vv)))

                if isfeedbacks == 1:
                    reqs96(Record(uid=uid,ttype='serp',reqid=reqid,slot=slot,ts=ts,q=q,ppp=str(ppp), ppp_vv=str(ppp_vv)))

            slot = '?'

            if r.HasTestID(c_7792):
                slot = '7792 control ' + c_7792
                exp = '7792'
            elif r.HasTestID(e1_7792):
                slot = '7792 exp ' + e1_7792
                exp = '7792'
            elif r.HasTestID(e2_7792):
                slot = '7792 exp ' + e2_7792
                exp = '7792'

            if slot != '?': # 7792 slot
                ppp = []

                isfeedbacks = 0
                for bl in r.GetBSBlocks():
                    p = bl.Path
                    for k in paths[exp]:
                        if k in p:
                            isfeedbacks = 1
                            if not p in ppp:
                                ppp.append(p)

                for cl in r.GetClicks():
                    p = cl.ConvertedPath
                    pp = cl.Path

                    for k in paths[exp]:
                        if k in pp or k in p:
                            c92(Record(uid=uid,ttype='click',reqid=reqid,slot=slot,ts=ts,q=q,isfeedbacks=isfeedbacks,p=p,pp=pp,vv=str(cl.GetVars()),ppp=str(ppp)))

                if isfeedbacks == 1:
                    reqs92(Record(uid=uid,ttype='serp',reqid=reqid,slot=slot,ts=ts,q=q,ppp=str(ppp)))

            slot = '?'

            if r.HasTestID(c_7793):
                slot = '7793 control ' + c_7793
                exp = '7793'
            elif r.HasTestID(e1_7793):
                slot = '7793 exp ' + e1_7793
                exp = '7793'
            elif r.HasTestID(e2_7793):
                slot = '7793 exp ' + e2_7793
                exp = '7793'

            if slot != '?': # 7793 slot
                ppp = []
                ppp_vv = []

                isfeedbacks = 0
                for bl in r.GetBSBlocks():
                    p = bl.Path
                    vv = str(bl.GetVars())
                    for k in paths[exp]:
                        if k in p and not 'fact-phone' in vv:
                            isfeedbacks = 1
                            if not p in ppp:
                                ppp.append(p)
                                ppp_vv.append(str(bl.GetVars()))

                for cl in r.GetClicks():
                    p = cl.ConvertedPath
                    vv = str(cl.GetVars())
                    pp = cl.Path

                    for k in paths[exp]:
                        if (k in pp or k in p) and not 'fact-phone' in vv:
                            c93(Record(uid=uid,ttype='click',reqid=reqid,slot=slot,ts=ts,q=q,isfeedbacks=isfeedbacks,p=p,pp=pp,vv=str(cl.GetVars()),ppp=str(ppp),ppp_vv=str(ppp_vv)))

                if isfeedbacks == 1:
                    reqs93(Record(uid=uid,ttype='serp',reqid=reqid,slot=slot,ts=ts,q=q,ppp=str(ppp), ppp_vv=str(ppp_vv)))

            slot = '?'

            if r.HasTestID(c_7794):
                slot = '7794 control ' + c_7794
                exp = '7794'
            elif r.HasTestID(e1_7794):
                slot = '7794 exp ' + e1_7794
                exp = '7794'
            elif r.HasTestID(e2_7794):
                slot = '7794 exp ' + e2_7794
                exp = '7794'

            if slot != '?': # 7794 slot
                ppp = []

                isfeedbacks = 0
                for bl in r.GetBSBlocks():
                    p = bl.Path
                    for k in paths[exp]:
                        if k in p:
                            isfeedbacks = 1
                            if not p in ppp:
                                ppp.append(p)

                for cl in r.GetClicks():
                    p = cl.ConvertedPath
                    pp = cl.Path

                    for k in paths[exp]:
                        if k in pp or k in p:
                            c94(Record(uid=uid,ttype='click',reqid=reqid,slot=slot,ts=ts,q=q,isfeedbacks=isfeedbacks,p=p,pp=pp,vv=str(cl.GetVars()),ppp=str(ppp)))

                if isfeedbacks == 1:
                    reqs94(Record(uid=uid,ttype='serp',reqid=reqid,slot=slot,ts=ts,q=q,ppp=str(ppp)))


cluster = clusters.yt.Hahn().env(templates=dict(
                                            job_root='home/search-research/ensuetina/FEEDBACK_EXPS/one_script'
                                            ))

dates = ['04-26','04-25','04-24','04-23','04-22','04-21','04-20']
for date in dates:
    #continue
    job = cluster.job()

    us = job.table('user_sessions/pub/search/daily/2016-' + date + '/clean')

#    us = job.table('userdata/user_sessions/2016-' + date)

    sh92, sh93, sh94, sh96, cl92, cl93, cl94, cl96 = us.groupby('key').sort('subkey').reduce(Reduce,files=[nile.files.LocalFile('/home/ensuetina/blockstat.dict'),
                                                                                                           nile.files.LocalFile('/home/ensuetina/libra.so')])

    sh92.put('$job_root/sh7792', append=True)
    sh93.put('$job_root/sh7793', append=True)
    sh94.put('$job_root/sh7794', append=True)
    sh96.put('$job_root/sh7796', append=True)
    cl92.put('$job_root/cl7792', append=True)
    cl93.put('$job_root/cl7793', append=True)
    cl94.put('$job_root/cl7794', append=True)
    cl96.put('$job_root/cl7796', append=True)

#    redir = job.table('statbox/redir-log/2016-' + date)
#    t = redir.map(map_redir).put('$job_root/feedback_clicks_modals')
#    t.groupby('expNo').aggregate(clicks=na.count()).put('$job_root/aggr_modals')

#    bs = job.table('statbox/blockstat-log/2016-' + date)
#    t = bs.map(map_bs).put('$job_root/bsb')
#    t.groupby('path').aggregate(clicks=na.count()).put('$job_root/aggr_bsb')

    job.run()




