# -*- coding: UTF-8 -*-
from nile import (
    filters as nf,
    aggregators as na
)

from nile.processing import Record
from nile.api.v1 import clusters
import nile
import uatraits, libra

from datetime import datetime

import urlparse

def Reduce(groups):
    c = '23151'
    e = '23152'

    detector = uatraits.detector('/usr/share/uatraits/browser.xml')

    for key, records in groups:
        uid = key.key
        if uid[0] != 'y':
            continue
        try:
            uid_date = uid[-10:]
        except:
            continue

        if int(uid_date) > 1450731600:
            age = 'NEW'
        else:
            age = 'OLD'

        uid_ts = str(datetime.fromtimestamp(float(uid_date)).isoformat()).split('T')[0]

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'Touch'
            else:
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

            if r.HasTestID(c):
                slot = 'control ' + c
                TI = 0
            elif r.HasTestID(e):
                slot = 'exp ' + e
                TI = 1
            else:
                continue

            SM = '-'
            spv = r.SearchPropsValues
            for k in spv:
                if 'REPORT.smartbanner' in k:
                    SM = k + '=' + str(spv[k])
                    break

            if len(SM) == 1:
                continue

            reqid = r.ReqID
            ref = str(r.Referer).split('?')[0]
            ua = str(r.UserAgent)
            d = detector.detect(ua)

            BR = ''
            BV = ''
            OS = ''
            OSV = ''

            if 'OSName' in d:
                OS = d['OSName']
            if 'OSVersion' in d:
                OSV = d['OSVersion']
            if 'BrowserName' in d:
                BR = d['BrowserName']
            if 'BrowserVersion' in d:
                BV = d['BrowserVersion']

            smClick = 0
            sm_close = 0
            for cl in r.GetClicks():
                p = cl.ConvertedPath
                if 'smartbanner/' in p:
                    if '/close' in p:
                        sm_close = 1

                    smClick = 1

            smsh = 0
            for bl in r.GetBSBlocks():
                p = bl.Path
                if 'smartbanner' in p:
                    smsh = 1
                    break

            yield Record(uid=uid,age=age,ts=ts,slot=slot,OS=OS,BR=BR,smClick=smClick,SM=SM,smsh=smsh,sm_close=sm_close)
            #yield Record(uid,'',slot + '\t' + uid_ts + '\t' + ts + '\t' + age + '\t' + str(csp) + '\t' + str(clck) + '\t' + str(isCl) + '\t' + ref + '\t' + ua, tableIndex = TI)

def map_bs(lines):
    paths = ['snippet/entity-fact/feedback','snippet/long_fact/feedback','snippet/suggest_fact/feedback','snippet/entity_search/object-badge/feedback','web/item/feedback']
    for line in lines:
        blocks = line.blocks

        for path in paths:
            if path in blocks and 'modal' in blocks:
                yield Record(path=path,blocks=blocks)
                break



def map_redir(lines):
    exp = {}
    exp['7793'] = ['23890','23891','23968']
    exp['7794'] = ['23894','23895','23901']
    exp['7796'] = ['23902','23965','23966']
    exp['7792'] = ['23889','23892','23893']

    paths = {}
    paths['254.1979.296'] = 'snippet/entity-search/feedback'
    paths['254.1985.296'] = 'snippet/long_fact/feedback'
    paths['254.1090.296'] = 'snippet/suggest_fact/feedback'
    paths['254.1950.2080.296'] = 'snippet/entity_search/object-badge/feedback'
    paths['80.22.296'] = 'web/item/feedback'
    for line in lines:
        s = line
        l = s.value

        data = dict([d.split('=', 1) for d in l.split('\t') if '=' in d])

        if not 'path' in data or not 'vars' in data or not 'slots' in data:
            continue

        uid = str(data.get('yandexuid'))
        slots = str(data.get('slots'))
        path = str(data.get('path'))
        vv = str(data.get('vars'))

        isS = 0
        for k in exp:
            if isS == 1:
                break
            for sl in exp[k]:
                if sl in slots:
                    slot = sl
                    expNo = k
                    isS = 1
                    break

        if isS == 0:
            continue

        for k in paths:
            if k in path and '.2171' in path:
                conv_path = paths[k]
                yield Record(uid=uid,slot=slot,expNo=expNo,path=path,conv_path=conv_path,vv=vv,log_line=l)
                break



cluster = clusters.yt.Hahn().env(templates=dict(
                                            job_root='home/search-research/ensuetina/FEEDBACK_EXPS'
                                            ))

dates = ['04-19']
for date in dates:
    #continue
    job = cluster.job()

#    redir = job.table('statbox/redir-log/2016-' + date)
#    t = redir.map(map_redir).put('$job_root/feedback_clicks_modals')
#    t.groupby('expNo').aggregate(clicks=na.count()).put('$job_root/aggr_modals')

    bs = job.table('statbox/blockstat-log/2016-' + date)
    t = bs.map(map_bs).put('$job_root/bsb')
    t.groupby('path').aggregate(clicks=na.count()).put('$job_root/aggr_bsb')

    job.run()




