# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
import sys
from datetime import datetime
import libra
import urllib
import random
import cgi


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except RuntimeError as e:
        if 'fat user' in str(e):
            return
        if 'ParseSession can' in str(e):
            return
        else:
            raise e

    Tags = ['13614','13613']

    f1 = f2 = 0

    for r in s:
        if not r.IsA("TYandexWebRequest"):
            continue

        isOrganic = 0
        url = str(r.FullRequest)
        qs = url.split('?',1)

        try:
            qs = qs[1]
            data = cgi.parse_qs(qs)

            if not 'ento' in data:
                isOrganic = 1
        except:
            isOrganic = 0

        q = urllib.unquote(r.Query)

        if r.HasTestID(Tags[0]):
            tag = Tags[0]
            yield Record(uid,'',str(isOrganic),tableIndex = 0)

            isSh = 0

            p1 = 'wiz/pseudo/eurovision_wizard'
            p2 = 'big-video/thumb'

            for bl in r.GetBSBlocks():
                p = bl.Path
                if p1 in p or p2 in p:
                    isSh = 1
                    break

            if isSh == 1:
                if f1 == 0:
                    f1 = 1
                    yield Record(uid,'','',tableIndex = 6)

                yield Record(uid,'',q + '\t' + str(isOrganic),tableIndex = 2)

                if isOrganic == 1:
                    yield Record(uid,'',q + '\t' + str(isOrganic),tableIndex = 4)

#                break

        elif r.HasTestID(Tags[1]):
            tag = Tags[1]
            yield Record(uid,'',str(isOrganic),tableIndex = 1)

            isSh = 0

            sp = r.SearchPropsValues
            if 'REPORT.pseudo_wizard_could_be_shown' in sp:
                if int(sp['REPORT.pseudo_wizard_could_be_shown']) == 1:
                    isSh = 1

            if isSh == 1:
                if f2 == 0:
                    f2 = 1
                    yield Record(uid,'','',tableIndex = 7)

                yield Record(uid,'',q + '\t' + str(isOrganic),tableIndex = 3)

                if isOrganic == 1:
                    yield Record(uid,'',q + '\t' + str(isOrganic),tableIndex = 5)

#                break


def main():

    MapReduce.useDefaults(
                            server   = 'cedar00.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['0521','0522','0524','0525','0526','0527']
#    dd = ['0523']
    for d in dd:
        src = 'user_sessions/2015' + d
        dt0 = 'ensuetina/EUROVISION/EXP/23/all_14'
        dt1 = 'ensuetina/EUROVISION/EXP/23/all_13'
        dt2 = 'ensuetina/EUROVISION/EXP/23/relev_14'
        dt3 = 'ensuetina/EUROVISION/EXP/23/relev_13'
        dt4 = 'ensuetina/EUROVISION/EXP/23/org_14'
        dt5 = 'ensuetina/EUROVISION/EXP/23/org_13'
        dt6 = 'ensuetina/EUROVISION/EXP/23/relev_uids_14'
        dt7 = 'ensuetina/EUROVISION/EXP/23/relev_uids_13'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1,dt2,dt3,dt4,dt5,dt6,dt7],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

if __name__ == '__main__':
    main()
