# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
import sys
from datetime import datetime
import libra
import urllib
import random
import cgi

def SimpleNormalize(q):
    forb = ['!','@','#','$','%','^','&','*','(',')','_','+','[',']','{','}','~',',','.','\\','/','?','<','>',':',';','\'','\"','-','=']

    for f in forb:
        q = q.replace(f,' ')

    while '  ' in q:
        q = q.replace('  ',' ')

    q = q.strip().lower()

    return q

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except RuntimeError as e:
        if 'fat user' in str(e):
            return
        if 'ParseSession can' in str(e):
            return
        else:
            raise e

    tags = ['13614','13613']

    for r in s:
        if not r.IsA("TYandexWebRequest"):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        q = urllib.unquote(r.Query).lower()
        q = SimpleNormalize(q)

        reqid = r.ReqID
        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        isOrganic = 0
        url = str(r.FullRequest)
        qs = url.split('?',1)
        if len(qs) < 2:
            yield Record(uid,'',ts + '\t' + q, tableIndex = 0) # errors
            continue

        qs = qs[1]
        data = cgi.parse_qs(qs)

        if not 'ento' in data:
            isOrganic = 1

        if r.HasTestID(tags[0]):
            slot = tags[0]

            isSh = 0

        elif r.HasTestID(tags[1]):
            slot = tags[1]

            isSh = 0

            sp = r.SearchPropsValues
            yield Record(uid,'',q + '\t' + str(sp), tableIndex = 3)

        else:
            continue


def main():

    MapReduce.useDefaults(
                            server   = 'cedar00.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['0521','0522','0523','0524','0525','0526','0527']
    dd = ['0523']
    for d in dd:
        src = 'user_sessions/2015' + d
        dt0 = 'ensuetina/EUROVISION/EXP/errors'
        dt1 = 'ensuetina/EUROVISION/EXP/all_relev_reqs_control'
        dt2 = 'ensuetina/EUROVISION/EXP/all_organic_reqs_control'
        dt3 = 'ensuetina/EUROVISION/EXP/searchprops_TRY'
        dt4 = 'ensuetina/EUROVISION/EXP/all_relev_reqs_exp'
        dt5 = 'ensuetina/EUROVISION/EXP/all_organic_reqs_exp'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1,dt2,dt3,dt4,dt5],
                            files = ['/home/ensuetina/data/blockstat.dict'],
#                            appendMode = True,
                            sortMode = True
                            )

if __name__ == '__main__':
    main()
