# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        uid_date = uid[-10:]
    except:
        return

    if int(uid_date) > 1444942799:
        new = 1
    else:
        new = 0

    uid_ts = str(datetime.fromtimestamp(float(uid_date)).isoformat()).split('T')[0]

    c = '17415'
    e = '17414'

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    TI = -1

    for r in s:
        if not r.IsA('TTouchYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

#        if r.HasTestID(c):
#            TI = 0
#            slot = 'control ' + c
#        elif r.HasTestID(e):
#            TI = 1
#            slot = 'exp ' + e
#        else:
#            continue

        if 'REPORT.test-ids' in r.SearchPropsValues.keys():
            #yield Record(uid,'',str(r.SearchPropsValues['REPORT.test-ids']))
            #continue
            if c in str(r.SearchPropsValues['REPORT.test-ids']):#.split():
                TI = 0
                slot = 'control ' + c
            elif e in str(r.SearchPropsValues['REPORT.test-ids']):#.split():
                TI = 1
                slot = 'exp ' + e
            else:
                continue
        else:
            continue

        yield Record(uid,'',slot + '\t' + ts + '\t' + str(uid_date) + '\t' + str(uid_ts), tableIndex = TI) # all reqs

    if TI != -1:
        yield Record(uid,'',slot + '\t' + ts + '\t' + str(uid_ts), tableIndex = TI + 2) # all uids

def transform(rec):
    yield Record(rec.value,'','')

def aggr(key,recs):
    yield Record(key,'','')


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['19']
    for d in dd:
        src = 'user_sessions/201510' + d

        dt0 = 'ensuetina/TOUCH_HTTPS/2/all_reqs_control'
        dt1 = 'ensuetina/TOUCH_HTTPS/2/all_reqs_exp'
        dt2 = 'ensuetina/TOUCH_HTTPS/2/all_uids_control'
        dt3 = 'ensuetina/TOUCH_HTTPS/2/all_uids_exp'

        dt4 = 'ensuetina/TOUCH_HTTPS/1/ALL_requests_control'
        dt5 = 'ensuetina/TOUCH_HTTPS/1/ALL_requests_exp'
        dt6 = 'ensuetina/TOUCH_HTTPS/1/ALL_users_control'
        dt7 = 'ensuetina/TOUCH_HTTPS/1/ALL_users_exp'

        dt = 'ensuetina/TOUCH_HTTPS/2/try'

        MapReduce.runMap(transform,
                         srcTable = dt,
                         dstTable = dt + '_transformed',
                         sortMode = True
                        )
        MapReduce.runReduce(aggr,
                            srcTable = dt + '_transformed',
                            dstTable = dt + '_aggr',
                            sortMode = True
                           )
        continue

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            #dstTable = dt,
                            dstTables = [dt0,dt1,dt2,dt3],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
