# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random
import sys

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    c = '18036'
    e = '18037'

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'tr':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        if r.HasTestID(c):
            TI = 0
            slot = 'control ' + c
        elif r.HasTestID(e):
            TI = 1
            slot = 'exp ' + e
        else:
            continue

        isCl = 0
        for cl in r.GetClicks():
            p = cl.ConvertedPath
            if 'wiz/panoramas' in p or 'wiz/museum_panoramas' in p:
                isCl = 1
                break

        yield Record(uid,'',str(isCl), tableIndex = TI)


def aggr(key,recs):
    isCl = 0
    for rec in recs:
        if int(rec.value) == 1:
            isCl = 1

    if isCl == 1:
        yield Record(key,'','', tableIndex = 1) # clicked
    else:
        yield Record(key,'','', tableIndex = 0) # not clicked


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    exp_days = ['1028','1029','1030','1031','1101','1102','1103']
    dd = ['1029','1030','1031','1101','1102','1103','1104','1105','1106','1107','1108','1109','1110','1111']
    for d in exp_days:
        src = 'user_sessions/2015' + d
        redir = 'redir_log/2015' + d

        dt0 = 'ensuetina/FOR_DVSH/1/control'
        dt1 = 'ensuetina/FOR_DVSH/1/exp'

#        continue

        MapReduce.runReduce(Reduce,
                           srcTable = src,
                           dstTables = [dt0,dt1],
                           files = ['/home/ensuetina/data/blockstat.dict'],
                           appendMode = True,
                           sortMode = True
                           )

    MapReduce.runReduce(aggr,
                        srcTable = dt0,
                        dstTables = [dt0 + '_no_clicks', dt0 + '_some_clicks'],
                        sortMode = True
                       )
    MapReduce.runReduce(aggr,
                        srcTable = dt1,
                        dstTables = [dt1 + '_no_clicks', dt1 + '_some_clicks'],
                        sortMode = True
                       )


if __name__ == '__main__':
    main()
