# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random
#import uatraits

#detector = uatraits.detector('/home/ensuetina/data/browser.xml')

def Reduce(key, recs):
    import uatraits

    detector = uatraits.detector('browser.xml')

    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    TI = -1

    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

#        br = r.GetBrowser()[0]
        ua = r.UserAgent
        d = detector.detect(ua)
        BrowserName = d.get('BrowserName')

        if BrowserName:
            if BrowserName == 'Chrome':
                for cl in r.GetClicks():
                    p = cl.ConvertedPath
                    if 'stripe/promobar' in p:
                        yield Record(uid,'',BrowserName + '\t' + p)
#            if 'Chrome' in br or 'Chrome' in BrowserName:
#                yield Record(br + '\t' + BrowserName + '\t' + ua, '','')

def Aggr(key,recs):
    freq = 0
    for rec in recs:
        freq += 1

    yield Record(key,'',str(freq))

def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['02']
    for d in dd:
        src = 'user_sessions/201511' + d

        dt0 = 'ensuetina/VALIDATE_CHROME/uatraits_promobar_clicks'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            #dstTable = dt,
                            dstTable = dt0,
                            files = ['/home/ensuetina/data/blockstat.dict',
                                     '/home/ensuetina/lib/UATRAITS/uatraits.so',
                                     '/home/ensuetina/lib/UATRAITS/libboost_python-py27.so.1.46.1',
                                     '/home/ensuetina/lib/UATRAITS/libuatraits.so.0',
                                     '/home/ensuetina/lib/UATRAITS/browser.xml'],
                            #appendMode = True,
                            sortMode = True
                            )
#    MapReduce.runReduce(Aggr,
#                        srcTable = dt0,
#                        dstTable = dt0 + '_aggr',
#                        sortMode = True
#                       )


if __name__ == '__main__':
    main()
