# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random
import httpagentparser
#from user_agents import parse


def Reduce(key, recs):
#    import uatraits

#    detector = uatraits.detector('browser.xml')

    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for r in s:
        if r.IsA('TPadYandexWebRequest'):
            ui = 'PAD'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ua = r.UserAgent
        reqid = r.ReqID

        for tech in r.GetYandexTechEvents():
            if not tech.IsA('TYandexTechEvent'):
                continue
            p = tech.Path
            if '71.143.1007' in p or 'serp.page.loaded' in p:
                vv = tech.Vars
                dd = dict([d.split('=', 1) for d in vv.split(',') if '=' in d])
                if '-viewport-size' in dd:
                    vps = dd['-viewport-size']

                    #yield Record(uid,'',ua + '\t' + myBR + '\t' + myBV + '\t' + myDevice + '\t' + uaBR + '\t' + uaBV + '\t' + uaOS + '\t' + uaDN + '\t' + uaDV + '\t' + vps)
                    yield Record(ua + '\t' + vps,'','')

def aggr(key,recs):
    yield Record(key,'','')

def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['1106']
    for d in dd:
        us = 'user_sessions/2015' + d

        dt0 = 'ensuetina/SERP_PAGE_LOADED/new/vps_ua'

        MapReduce.runReduce(Reduce,
                            srcTable = us,
                            dstTable = dt0,
                            files = ['/home/ensuetina/data/blockstat.dict'#,
                                     #'/home/ensuetina/lib/UATRAITS/uatraits.so',
                                     #'/home/ensuetina/lib/UATRAITS/libboost_python-py27.so.1.46.1',
                                     #'/home/ensuetina/lib/UATRAITS/libuatraits.so.0',
                                     #'/home/ensuetina/lib/UATRAITS/browser.xml'
                                     ],
                            #appendMode = True,
                            sortMode = True
                            )
        MapReduce.runReduce(aggr,
                            srcTable = dt0,
                            dstTable = dt0 + '_aggr',
                            sortMode = True
                           )


if __name__ == '__main__':
    main()
