# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'DESKTOP'
        elif r.IsA('TPadYandexWebRequest'):
            ui = 'PAD'
        elif r.IsA('TTouchYandexWebRequest'):
            ui = 'TOUCH'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        q = normalize_query(r.Query)

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            if not 'serp/region/lower/message' in p:
                continue

            status = '-'
            vtype = '-'
            vv = cl.GetVars()
            for v in vv:
                if '-type' in v:
                    vtype = str(v)
                if '-status' in v:
                    status = str(v)

            yield Record(uid,'',ts + '\t' + q + '\t' + p + '\t' + vtype + '\t' + status + '\t' + str(vv) + '\t' + ui)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['14','15']
    for d in dd:
        src = 'user_sessions/201510' + d

        dt0 = 'ensuetina/SEARCH_NEARBY/clicks_ui'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt0,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
