# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for r in s:
        if r.IsA('TTouchYandexWebRequest'):
            if r.ServiceDomRegion != 'ru':
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
            q = normalize_query(r.Query)

            i = 0
            for bl in r.GetMainBlocks():
                m = bl.GetMainResult()
                if m.IsA('TWizardResult'):
                    p = m.ConvertedPath
                    if 'entity_search' in p:
                        yield Record(uid,'',q + '\t' + p + '\t' + str(i), tableIndex = 0)
                i += 1

        elif r.IsA('TPadYandexWebRequest'):
            if r.ServiceDomRegion != 'ru':
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
            q = normalize_query(r.Query)
            y1 = 0
            y2 = 0
            for bl in r.GetBSBlocks():
                p = bl.Path
                vv = bl.GetVars()
                if 'wiz/entity_search' in p and y1 == 0:
                    yield Record(uid,'',q + '\t' + p + '\t' + str(vv), tableIndex = 1)
                    y1 = 1
                if 'parallel/object-answer' in p and y2 == 0:
                    yield Record(uid,'',q + '\t' + p + '\t' + str(vv), tableIndex = 1)
                    y2 = 1



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['28']
    for d in dd:
        src = 'user_sessions/201510' + d

        dt0 = 'ensuetina/RESEARCH-1545/touch'
        dt1 = 'ensuetina/RESEARCH-1545/pad'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
