# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        uid_date = uid[-10:]
    except:
        return

    if int(uid_date) > 1444424400:
        cookie = 'NEW COOKIE'
    else:
        cookie = 'OLD COOKIE'

    uid_ts = str(datetime.fromtimestamp(float(uid_date)).isoformat()).split('T')[0]

    pad_c = '17655'
    pad_e = '17654'

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    TI = -1

    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        reg = r.ServiceDomRegion
        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        if r.HasTestID(pad_c):
            TI = 0
            slot = 'control ' + pad_c
        elif r.HasTestID(pad_e):
            TI = 1
            slot = 'exp ' + pad_e
        else:
            continue

        yield Record(uid,'',cookie + '\t' + slot + '\t' + ts + '\t' + str(uid_date) + '\t' + str(uid_ts), tableIndex = TI) # all reqs


def transform(rec):
    yield Record(rec.value,'','')

def aggr(key,recs):
    yield Record(key,'','')


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['20','21','22','23','24','25','26','27']
    for d in dd:
        src = 'user_sessions/201510' + d

        dt0 = 'ensuetina/HTTPS_EXPERIMENTS/PADS/pads_control'
        dt1 = 'ensuetina/HTTPS_EXPERIMENTS/PADS/pads_exp'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
