# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random


def Reduce(key, recs):
    import uatraits

    detector = uatraits.detector('browser.xml')

    uid = key
    if uid[0] != 'y':
        return

    try:
        uid_date = uid[-10:]
    except:
        return

    if int(uid_date) > 1445288400:
        cookie = 'NEW COOKIE'
    else:
        cookie = 'OLD COOKIE'

    uid_ts = str(datetime.fromtimestamp(float(uid_date)).isoformat()).split('T')[0]

    touch_c = '18334'
    touch_e = '18335'

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    TI = -1

    for r in s:
        if not r.IsA('TTouchYandexWebRequest'):
            continue

        if not r.ServiceDomRegion in ['ru','by','ua','kz']:
            continue

        reg = r.ServiceDomRegion
        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        ua = r.UserAgent

        data = detector.detect(ua)
        BR = str(data.get('BrowserName'))
        BV = str(data.get('BrowserVersion'))
        OS = str(data.get('OSName'))
        OSF = str(data.get('OSFamily'))

        if r.HasTestID(touch_c):
            TI = 0
            slot = 'control ' + touch_c
        elif r.HasTestID(touch_e):
            TI = 1
            slot = 'exp ' + touch_e
        else:
            continue

        yield Record(uid,'',cookie + '\t' + slot + '\t' + ts + '\t' + str(uid_ts) + '\t' + BR + '\t' + BV + '\t' + OS + '\t' + OSF, tableIndex = TI)


def transform(rec):
    yield Record(rec.value,'','')

def aggr(key,recs):
    yield Record(key,'','')


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['1105']
    for d in dd:
        src = 'user_sessions/2015' + d

        dt0 = 'ensuetina/HTTPS_EXPERIMENTS/TOUCH/NEWEXP/control'
        dt1 = 'ensuetina/HTTPS_EXPERIMENTS/TOUCH/NEWEXP/exp'

        continue

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict',
                                     '/home/ensuetina/lib/UATRAITS/uatraits.so',
                                     '/home/ensuetina/lib/UATRAITS/libboost_python-py27.so.1.46.1',
                                     '/home/ensuetina/lib/UATRAITS/libuatraits.so.0',
                                     '/home/ensuetina/lib/UATRAITS/browser.xml'
                                    ],
                            #appendMode = True,
                            sortMode = True
                            )

    MapReduce.runReduce(aggr,
                        srcTable = dt0,
                        dstTable = dt0 + '_uids',
                        sortMode = True
                       )
    MapReduce.runReduce(aggr,
                        srcTable = dt1,
                        dstTable = dt1 + '_uids',
                        sortMode = True
                       )


if __name__ == '__main__':
    main()
