# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

def map_redir(rec):
    line = rec.value
    data = dict([d.split('=', 1) for d in line.split('@@') if '=' in d])
    l = line.split('@@')
    try:
        uid = l[-1]
        ts = l[-3]
    except:
        return

    if len(str(uid)) < 10:
        return

    try:
        date =  str(datetime.fromtimestamp(float(ts)).isoformat()).split('T')[0]
    except:
        date = '-'

    if not 'path' in data:
        return

    path = data['path']
    if not 'chrome.markdone.yoshow' in path:
        return

    yield Record('y'+str(uid),'',date + '\t' + ts + '\t' + path)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['1012','1013','1014','1015','1016','1017']
    for d in dd:
        src = 'redir_log/2015' + d

        dt = 'ensuetina/YOBJECT_RETENTION/result_new'

        MapReduce.runMap(map_redir,
                         srcTable = src,
                         dstTable = dt,
                         appendMode = True,
                         sortMode = True
                        )


if __name__ == '__main__':
    main()
