# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    c = '18157'
    e = '18158'

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        if r.HasTestID(c):
            TI = 0
            slot = 'control ' + c
        elif r.HasTestID(e):
            TI = 1
            slot = 'exp ' + e
        else:
            continue

        sp = r.SearchPropsValues
        if 'REPORT.default_search_wizard' in sp.keys():
            yield Record(uid,'',ts + '\t' + str(sp.keys()) + '\t' + str(sp['REPORT.default_search_wizard']),tableIndex = TI)
        else:
            yield Record(uid,'',ts + '\t' + str(sp.keys()), tableIndex = TI + 2)

def aggr(key,recs):
    uid = key
    isSp = 0
    for rec in recs:
        if len(rec.value.split('\t')) == 3:
            isSp = 1
            break

    if isSp == 0:
        yield Record(uid,'','')


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['06','07','08','09','10','11','12','13','14','15','16','17','18','19']
    for d in dd:
        src = 'user_sessions/201511' + d

        dt0 = 'ensuetina/SEARCH_PROPS_UIDS/SP_control'
        dt1 = 'ensuetina/SEARCH_PROPS_UIDS/SP_exp'
        dt2 = 'ensuetina/SEARCH_PROPS_UIDS/not_SP_control'
        dt3 = 'ensuetina/SEARCH_PROPS_UIDS/not_SP_exp'

        continue

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1,dt2,dt3],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )
    MapReduce.runReduce(aggr,
                        srcTables = [dt0,dt2],
                        dstTable = 'ensuetina/SEARCH_PROPS_UIDS/1/not_SP_control_uids',
                        sortMode = True
                       )

    MapReduce.runReduce(aggr,
                        srcTables = [dt1,dt3],
                        dstTable = 'ensuetina/SEARCH_PROPS_UIDS/1/not_SP_exp_uids',
                        sortMode = True
                       )

#    MapReduce.runReduce(aggr,
#                        srcTable = dt2,
#                        dstTable = dt2 + '_uids',
#                        sortMode = True
#                       )

#    MapReduce.runReduce(aggr,
#                        srcTable = dt3,
#                        dstTable = dt3 + '_uids',
#                        sortMode = True
#                       )


if __name__ == '__main__':
    main()
