# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    qlist = ['acil aşk aranıyor', 'adı mutluluk', 'akasya durağı', 'american horror story', 'arka sokaklar', 'arkadaşım hoşgeldin', 'arrow', 'asi', 'aşk yeniden',
             'asla vazgeçmem', 'ateş ve su', 'baba candır', 'behzat ç', 'beni affet', 'beyaz show', 'bez bebek', 'big bang ory', 'bir deniz hikayesi', 'bleach',
             'bones', 'breaking bad', 'buyur burdan bak', 'cennet mahallesi', 'cilek kokusu', 'çilek kokusu', 'da vinci demons', 'deniz yıldızı', 'dexter', 'diriliş',
             'diriliş ertuğrul', 'doctor who', 'ekip 1', 'empire', 'ena', 'eşkiya dünyaya hükümdar olmaz', 'esrarengiz kasaba', 'eve dönüş', 'evleneceksen gel',
             'evli ve öfkeli', 'ezel', 'filinta', 'friends', 'fringe', 'game of thrones', 'gotham', 'güldür güldür', 'güllerin savaşı', 'gunesin kizlari',
             'güneşin kızları', 'harika kanatlar', 'hatırla gönül', 'helix', 'heroes', 'homeland', 'house', 'how i met your mor', 'iki dünya arasında',
             'ilişki durumu karışık', 'inadına aşk', 'işte benim stilim', 'kaderimin yazildigi gun', 'kaderimin yazıldığı gün', 'kalbim ege de kaldı', 'kara ekmek',
             'kara sevda', 'karadayı', 'karagül', 'kardeş payı', 'karlar ülkesi', 'kertenkele', 'kiralik ask', 'kiralık aşk', 'kiraz mevsimi', 'kırgın çiçekler',
             'kısmetse olur', 'kocamın ailesi', 'küçük ağa', 'küçük gelin', 'kurtlar vadisi', 'kurtlar vadisi pusu', 'kvp', 'leyla ile mecnun', 'limitless', 'lost',
             'maral', 'medcezir', 'monster high', 'mr robot', 'müge anlı', 'muhteşem yüzyıl', 'narcos', 'naruto', 'niloya', 'ninjago', 'nizama adanmış ruhlar',
             'o hayat benim', 'o ses türkiye', 'once upon a time', 'one piece', 'one punch man', 'originals', 'öyle bir geçer zamanki', 'paramparca', 'paramparça',
             'pepe', 'person of interest', 'pokemon', 'poyraz karayel', 'pretty little liars', 'prison break', 'rafadan tayfa', 'sakarya fırat', 'scooby doo',
             'şefkat tepe', 'seksenler', 'shameless', 'sherlock holmes', 'sihirli annem', 'simpsons', 'skins', 'son çıkış', 'south park', 'spartacus', 'suits',
             'sünger bob', 'sungurlar', 'supergirl', 'supernatural', 'tatlı küçük yalancılar', 'teen wolf', 'tom ve jerry', 'true detective', 'unutma beni',
             'ütopya', 'vampire diaries', 'vikings', 'walking dead', 'winx', 'yeşil deniz', 'yılanların öcü', 'zengin kız fakir oğlan', 'topkapı sarayı',
             'ayasofya', 'yerebatan', 'eyüpsultan', 'kutsal emanet', 'galata', 'dolmabahçe', 'boğaz', 'aspendos', 'kaleiçi', 'perge', 'hadrian kapısı',
             'karaalioğlan park', 'çanakkale şehitler anıt', 'conkbayırı', 'seyit onbaşı anıt', 'kilitbahir kalesi', 'anzak koyu', 'bodrum marina', 'kapadokya',
             'pamukkale', 'bozcaada', 'alaçatı', 'ölüdeniz', 'belek', 'miniatürk', 'rahmi koç müzesi', 'i̇çmeler plajı', 'atakule', 'kocatepe camii',
             'kızılay meydanı', 'tunalı hilmi', 'ankara kalesi', 'güvenpark', 'kuğulu park', 'marmaris kordon', 'marmaris sahil', 'sakarya uzunçarşı', 'göreme',
             'bursa yeşil camii', 'bursa kapalıçarşı', 'cumalıkızık', 'kızılvadi', 'adana taşköprü', 'afyon', 'akhan kervansarayı', 'aleaddin keykubat camii',
             'artuklu sarayı', 'beşköprü', 'bodrum antik tiyatro', 'darıca hayvanat bahçesi', 'dengbej evi', 'deprem ve kültür müzesi', 'gümüşlük sahili',
             'hierapolis', 'i̇zmit saat kulesi', 'denizli kaleiçi', 'i̇nce minare müzesi', 'karahisar kalesi', 'karasu', 'kayaköy antik kenti', 'fethiye kordon',
             'laodikeia', 'malabadi köprüsü', 'diyarbakır surları', 'mevlana müzesi', 'namık kemal evi', 'ongözlü köprü', 'sapanca gölü', 'sabancı merkez camii',
             'surp giragos kilisesi', 'diyarbakır ulu camii', 'afyon ulu camii', 'ölüdeniz sahili', 'tekidağ sahili', 'i̇stanbul panorama', 'ankara panorama',
             'i̇zmi panorama', 'bursa panorama', 'didi panorama', 'kocaeli panorama', 'kuşadas panorama', 'alany panorama', 'antaly panorama', 'çanakkale panorama',
             'eskişehir panorama', 'afyonkarahisar panorama', 'fethiye panorama', 'kemer panorama', 'marmaris panorama', 'nevşehir panorama', 'sakarya panorama',
             'minsk panorama', 'moskova panorama', 'krasnodar panorama', 'bozcaada  panorama', 'alaçatı  panorama', 'ölüdeniz  panorama', 'pamukkale  panorama',
             'belek  panorama', 'çernobil panorama', 'donetsk panorama', 'kiev panorama', 'lviv panorama', 'odessa panorama', 'kharkiv panorama', 'sankt panorama',
             'soçi panorama', 'kazan panorama', 'ekaterinburg panorama', 'kırım panorama', 'sankt petersburg panorama'
            ]

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'tr':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        q = normalize_query(r.Query)

        if len(q) == 0:
            continue

        isQ = 0
        for el in qlist:
            if el in q:
                isQ = 1
                marker = el
                break

        if isQ == 0:
            continue

        isWiz = 0
        wiz = ''

        for bl in r.GetBSBlocks():
            p = bl.Path
            if 'wiz/default_search' in p:
                isWiz = 1
                wiz = p
                break

        yield Record(uid,'',ts + '\t' + q + '\t' + marker + '\t' + str(isWiz) + '\t' + wiz)



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['24','25']
    for d in dd:
        src = 'user_sessions/201511' + d

        dt = 'ensuetina/TR_DISTRIB_WIZARD_COVERAGE/data'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
