# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '18822'
    e = '18823'

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        if r.HasTestID(c):
            slot = 'control ' + c
            TI = 0
        elif r.HasTestID(e):
            slot = 'exp ' + e
            TI = 1
        else:
            continue

        mkb = 0
        pseudo_all = 0
        pseudo_one = 0
        pseudo_chrome = 0
        stripe = 0

        mkb_cl = 0
        pseudo_all_cl = 0
        pseudo_one_cl = 0
        pseudo_chrome_cl = 0
        stripe_cl = 0

        for bl in r.GetBSBlocks():
            p = bl.Path
            if 'bs_stats/banners/mkb' in p:
                mkb = 1
            if 'snippet/pseudo_fast/' in p:
                if 'browsers_all' in p:
                    pseudo_all = 1
                elif 'browser__one_chrome' in p:
                    pseudo_chrome = 1
                elif 'browser__one_' in p:
                    pseudo_one = 1
            if 'stripe/promobar' in p:
                stripe = 1

        if mkb + pseudo_all + pseudo_one + pseudo_chrome + stripe == 0:
            continue

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            if 'bs_stats/banners/mkb' in p:
                mkb_cl += 1
            elif 'snippet/pseudo_fast/' in p:
                if 'browsers_all' in p:
                    pseudo_all_cl += 1
                elif 'browser__one_chrome' in p:
                    pseudo_chrome_cl += 1
                elif 'browser__one_' in p:
                    pseudo_one_cl += 1
                else:
                    continue
            elif 'stripe/promobar' in p:
                stripe_cl += 1
            else:
                continue

            yield Record(uid,'',ts + '\t' + slot + '\t' + r.ReqID + '\t' + p, tableIndex = 1)

        yield Record(uid,'',ts + '\t' + slot + '\t' + r.ReqID + '\t' + str(mkb) + '\t' + str(pseudo_all) + '\t' + str(pseudo_one) + '\t' + str(pseudo_chrome) + '\t' + str(stripe) + '\t' + str(mkb_cl) + '\t' + str(pseudo_all_cl) + '\t' + str(pseudo_chrome_cl) + '\t' + str(pseudo_one_cl) + '\t' + str(stripe_cl), tableIndex = 0)

def get_ctrs(key,recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        mkb = 0
        pseudo_all = 0
        pseudo_one = 0
        pseudo_chrome = 0
        stripe = 0

        mkb_cl = 0
        pseudo_all_cl = 0
        pseudo_one_cl = 0
        pseudo_chrome_cl = 0
        stripe_cl = 0

        for bl in r.GetBSBlocks():
            p = bl.Path
            if 'bs_stats/banners/mkb' in p:
                mkb = 1
            if 'snippet/pseudo_fast/' in p:
                if 'browsers_all' in p:
                    pseudo_all = 1
                elif 'browser__one_chrome' in p:
                    pseudo_chrome = 1
                elif 'browser__one_' in p:
                    pseudo_one = 1
            if 'stripe/promobar' in p:
                stripe = 1

        if pseudo_all + pseudo_one + pseudo_chrome + stripe == 0:
            continue

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            if 'bs_stats/banners/mkb' in p:
                mkb_cl += 1
            elif 'snippet/pseudo_fast/' in p:
                if 'browsers_all' in p:
                    pseudo_all_cl += 1
                elif 'browser__one_chrome' in p:
                    pseudo_chrome_cl += 1
                elif 'browser__one_' in p:
                    pseudo_one_cl += 1
                else:
                    continue
            elif 'stripe/promobar' in p:
                stripe_cl += 1
            else:
                continue

        yield Record(uid,'',ts + '\t' + slot + '\t' + r.ReqID + '\t' + str(mkb) + '\t' + str(pseudo_all) + '\t' + str(pseudo_one) + '\t' + str(pseudo_chrome) + '\t' + str(stripe) + '\t' + str(mkb_cl) + '\t'     + str(pseudo_all_cl) + '\t' + str(pseudo_chrome_cl) + '\t' + str(pseudo_one_cl) + '\t' + str(stripe_cl))



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20151203', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20151209):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt0 = 'ensuetina/MKB_EXP/data_full'
        dt1 = 'ensuetina/MKB_EXP/clicks'

        MapReduce.runReduce(get_ctrs,
                            srcTable = src,
                            dstTable = dt0,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
