# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '18142'
    e = '18145'

    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]


        if r.HasTestID(c):
            slot = 'control ' + c
            TI = 0
        elif r.HasTestID(e):
            slot = 'exp ' + e
            TI = 1
        else:
            continue

        sp = r.SearchPropsValues
        if not 'FASTRES_PROXY.FastResApplicable' in sp:
            continue

        spv = sp['FASTRES_PROXY.FastResApplicable']
        if not 'vilenkin' in spv:
            continue

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            url = str(cl.Url)

            if 'vcevce.ru' in url or 'snippet/pseudo_fast/solver/' in p:
                yield Record(uid,'',ts + '\t' + slot + '\t' + spv + '\t' + p + '\t' + url)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20151202', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20151216):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt = 'ensuetina/VILENKIN/data'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
