# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '17408'
    e = '17405'

    for r in s:
        if r.IsA('TTouchYandexWebRequest'):
            ui = 'Touch search'
        elif r.IsA('TTouchYandexImagesRequest'):
            ui = 'Touch images'
        elif r.IsA('TYandexVideoRequest'):
            ui = 'video'
        elif r.IsA('TTouchYandexPortalRequest'):
            ui = 'Touch morda'
        else:
            continue


        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]


        if r.HasTestID(c):
            slot = 'control ' + c
            TI = 0
        elif r.HasTestID(e):
            slot = 'exp ' + e
            TI = 1
        else:
            continue

        if r.YandexLoginHash:
            yield Record(uid,'',slot + '\t' + ts + '\t' + ui, tableIndex = TI)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20151021', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20151113):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt0 = 'ensuetina/GET_LOGINS/c'
        dt1 = 'ensuetina/GET_LOGINS/e'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
