#-*-coding: utf8 -*-

from nile import (
    clusters,
    Record,
    filters as nf,
    aggregators
)
import nile
import uatraits, libra

import urlparse

def Reduce(groups):
    for key, records in groups:
        uid = key.key
        if uid[0] != 'y':
            continue

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            return

        for r in session:
            if r.IsA('TPadYandexWebRequest'):
                yield Record(uid=uid)
                break

username = 'ensuetina'
cluster = clusters.Plato().env(
                                job_root=('home/search-research/' + username + '/'
                                         'nile/5K_pad_users') # directory on plato where i plan to store results
                            )
dates = nile.api.path.DateRange('20160112', '20160112')
for date in dates:
    job = cluster.job().env(date=date)

    log = job.table('userdata/user_sessions/$date')

    queries = job.table('$job_root/result')

#    queries = log.groupby('key').sort('subkey').reduce(Reduce,files=[nile.files.LocalFile('blockstat.dict'),nile.files.LocalFile('libra.so')]).put('$job_root/result')
    top = queries.random(count=5000).put('$job_root/5K_uids')

    job.run()

