# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '19112'
    e = '19114'

    for r in s:
        if not r.IsA('TYandexWebRequest'):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        q = str(r.Query)

        if r.HasTestID(c):
            slot = 'control ' + c
        elif r.HasTestID(e):
            slot = 'exp ' + e
        else:
            continue

        sp = r.SearchPropsValues
        reqid = r.ReqID
        spF = sp.get('UPPER.EntitySearch.Log')
        if '|Film' in str(spF):
            isSp = str(spF)
        else:
            isSp = '-1'

#        yield Record(slot + '\t' + isSp,'','',tableIndex = 0) # reqs

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            url = str(cl.Url)
            dw = cl.DwellTimeOnService
            if 'kinopoisk.ru' in url:
                yield Record(uid,'',ts + '\t' + slot + '\t' + isSp + '\t' + p + '\t' + url + '\t' + str(dw), tableIndex = 1) # clicks

def aggr(key,recs):
    i = 0
    for rec in recs:
        i += 1

    yield Record(key,'',str(i))



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['05','06','07','08','09','10']
    for d in dd:
        src = 'user_sessions/201512' + d

        dt0 = 'ensuetina/OA_KP_TRAFFIC/reqs'
        dt1 = 'ensuetina/OA_KP_TRAFFIC/clicks'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )
#    MapReduce.runReduce(aggr,
#                        srcTable = dt0,
#                        dstTable = dt0 + '_aggr',
#                        sortMode = True
#                       )


if __name__ == '__main__':
    main()
