# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '19637'
    e1 = '19638'
    e2 = '19639'
    e3 = '19640'
    e4 = '19641'
    e5 = '19642'
    e6 = '19643'

    e = [e1,e2,e3,e4,e5,e6]

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'tr':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        q = r.Query

        TI = -1

        if r.HasTestID(c):
            slot = 'control ' + c
            TI = 0
        else:
            for el in e:
                if r.HasTestID(el):
                    slot = 'exp ' + el
                    TI = 1

        if TI == -1:
            continue

        isComp = 0
        isYmaps = 0

        wiz_pos = -1
        org_pos = -1
        for bl in r.GetBSBlocks():
            p = bl.Path
            vv = bl.GetVars()
            if 'snippet/companies' in p:
                isComp = 1
            elif 'snippet/address_ymaps' in p:
                isYmaps = 1
            else:
                continue

            for v in vv:
                if v[0] == 'pos':
                    try:
                        wiz_pos = int(v[1].replace('p',''))
                    except:
                        wiz_pos = 'err - ' + str(v[1])

        if isComp + isYmaps == 0:
            continue

        isWin = 0
        isLoss = 0

        if isComp == 1:
            for cl in r.GetClicks():
                p = cl.ConvertedPath
                vv = str(cl.GetVars())
                dw = cl.DwellTimeOnService

                if 'snippet/companies' in p:
                    if int(dw)>15:
                        isWin = 1
                    yield Record(uid,'','snip\t' + slot + '\t' + ts + '\t' + p + '\t' + vv + '\t' + str(dw), tableIndex = 1) # clicks

            i = 0
            if 'err' in str(wiz_pos):
                pos = 0
            else:
                pos = wiz_pos

            for  bl in r.GetMainBlocks():
                m = bl.GetMainResult()
                if m.IsA('TWebResult'):
                    org_pos = m.Position
                    if int(org_pos) != pos + 1:
                        continue
                    for cl in bl.GetClicks():
                        p = cl.ConvertedPath
                        vv = str(cl.GetVars())
                        dw = cl.DwellTimeOnService
                        if int(dw)>15:
                            isLoss = 1
                        yield Record(uid,'','organic l\t' + slot + '\t' + ts + '\t' + p + '\t' + vv + '\t' + str(dw), tableIndex = 1) # clicks
                    break
        elif isYmaps == 1:
            for cl in r.GetClicks():
                p = cl.ConvertedPath
                vv = str(cl.GetVars())
                dw = cl.DwellTimeOnService

                if 'snippet/address_ymaps' in p:
                    if int(dw)>15:
                        isWin = 1
                    yield Record(uid,'','snip\t' + slot + '\t' + ts + '\t' + p + '\t' + vv + '\t' + str(dw), tableIndex = 1) # clicks

            f = 0
            for  bl in r.GetMainBlocks():
                m = bl.GetMainResult()
                if m.IsA('TWebResult') and f == 0:
                    f = 1
                    for cl in bl.GetClicks():
                        p = cl.ConvertedPath
                        vv = str(cl.GetVars())
                        dw = cl.DwellTimeOnService
                        if int(dw)>15:
                            isWin = 1
                        yield Record(uid,'','organic w\t' + slot + '\t' + ts + '\t' + p + '\t' + vv + '\t' + str(dw), tableIndex = 1) # clicks
                if (not m.IsA('TDirectResult')) and f == 1:
                    for cl in bl.GetClicks():
                        p = cl.ConvertedPath
                        vv = str(cl.GetVars())
                        dw = cl.DwellTimeOnService
                        if int(dw)>15:
                            isLoss = 1
                        yield Record(uid,'','organic l\t' + slot + '\t' + ts + '\t' + p + '\t' + vv + '\t' + str(dw), tableIndex = 1) # clicks
                        break

        yield Record(uid,'',slot + '\t' + ts + '\t' + q + '\t' + str(isComp) + '\t' + str(isYmaps) + '\t' + str(isWin) + '\t' + str(isLoss) + '\t' + str(wiz_pos) + '\t' + str(org_pos), tableIndex = 0)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20151219', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20151225):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt0 = 'ensuetina/COMPANIES_WIZ_SURPLUS/2/data'
        dt1 = 'ensuetina/COMPANIES_WIZ_SURPLUS/2/clicks'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
