# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '19637'
    e1 = '19638'
    e2 = '19639'
    e3 = '19640'
    e4 = '19641'
    e5 = '19642'
    e6 = '19643'

    e = [e1,e2,e3,e4,e5,e6]

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'tr':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        q = r.Query

        TI = -1

        if r.HasTestID(c):
            slot = 'control ' + c
            TI = 0
        else:
            for el in e:
                if r.HasTestID(el):
                    slot = 'exp ' + el
                    TI = 1

        if TI == -1:
            continue

        isComp = 0
        isYmaps = 0

        for bl in r.GetBSBlocks():
            p = bl.Path
            vv = bl.GetVars()
            if 'snippet/companies' in p:
                isComp = 1
            elif 'snippet/address_ymaps' in p:
                isYmaps = 1
            else:
                continue

            spv = r.SearchPropsValues
            SingleOrgMx = ''
            OrgWizard = ''

            for k in spv.keys():
                if 'SingleOrgMx' in k and 'OrgMnMxType' in k:
                    SingleOrgMx = k + '=' + spv[k]
                if 'OrgWizard' in k and 'QueryType' in k:
                    OrgWizard = k + '=' + spv[k]

            if isComp + isYmaps + len(SingleOrgMx) + len(OrgWizard) > 0:
                yield Record(uid,'',slot + '\t' + str(isComp) + '\t' + str(isYmaps) + '\t' + SingleOrgMx + '\t' + OrgWizard)

def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20151222', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20151223):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt0 = 'ensuetina/COMPANIES_WIZ_SURPLUS/validate_spv/data'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt0,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
