# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '19985'
    e = '19986'

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        if r.HasTestID(c):
            slot = 'control ' + c
            TI = 0
        elif r.HasTestID(e):
            slot = 'exp ' + e
            TI = 1
        else:
            continue

        isKP = 0
        for bl in r.GetMainBlocks():
            m = bl.GetMainResult()
            if m.IsA('TWebResult'):
                url = str(m.Url)
                if 'kinopoisk.ru' in url:
                    isKP = 1
                    break

        for cl in r.GetClicks():
            url = str(cl.Url)
            p = cl.ConvertedPath
            dw = cl.DwellTimeOnService
            if 'kinopoisk.ru' in url:
                yield Record(uid,'',ts + '\t' + slot + '\t' + str(isKP) + '\t' + p + '\t' + url + '\t' + str(dw))


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20160113', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20160120):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt = 'ensuetina/KP_TRAFFIC_DIFF/data'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
