# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    for r in s:
        if r.IsA('TTouchYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        date =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        ts = r.Timestamp

        q = normalize_query(r.Query)

        if len(q) == 0:
            continue

        yield Record((uid + '\t' + q)[:200],str(ts),'')

def get_hist(key,recs):
    l = key.split('\t')
    uid = l[0]
    q = l[1]

    prev = None
    for rec in recs:
        if not prev:
            prev = rec.subkey
            continue

        curr = rec.subkey
        delta = int(curr) - int(prev)
        yield Record(q + '\t' + str(delta),'',str(prev) + '\t' + str(curr))

        prev = curr

def map_sk(rec):
    yield Record(rec.key,rec.value,'')

def aggr_deltas(key,recs):
    i = 0
    for rec in recs:
        i += 1

    yield Record(key,'',str(i))

def map_deltas(rec):
    k = rec.key.split('\t')
#    try:
#        delta = k[1]
#    except:
#        return

    yield Record(k[1],'',k[0])


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20160111', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20160211):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt = 'ensuetina/QUERIES_HISTOGRAM/TOUCH/all_q'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')

#    MapReduce.runMap(map_sk,
#                     srcTable = dt,
#                     dstTable = dt + '_sk',
#                     sortMode = True
#                    )

    MapReduce.runReduce(get_hist,
                        srcTable = dt,
                        dstTable = dt + '_deltas',
                        sortMode = True
                       )

    MapReduce.runMap(map_deltas,
                        srcTable =  dt + '_deltas',
                        dstTable = dt + '_deltas_only',
                        sortMode = True
                       )

    MapReduce.runReduce(aggr_deltas,
                        srcTable = dt + '_deltas_only',
                        dstTable = dt + '_deltas_only_aggr',
                        sortMode = True
                       )


if __name__ == '__main__':
    main()
