# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    sess = -1
    for r in s:
        if r.IsA('TTouchYandexWebRequest'):
            ui = 'Touch'
        elif r.IsA('TPadYandexWebRequest'):
            ui = 'Tablet'
        elif r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts = r.Timestamp
        day =  str(datetime.fromtimestamp(ts).isoformat()).split('T')[0]

        if sess == -1:
            prev = ts
            sess = 0
        elif ts - prev > 1800:
            sess += 1

        q = normalize_query(r.Query)

        if len(q) == 0:
            continue

        req = str(r.FullRequest)
        if not '&ento=' in req:
            prev = ts
            continue

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            url = str(cl.Url)
            #if '&ento=' in url:
            if 'kinopoisk.ru' in url:
                urltype = 'kinopoisk'
            elif 'wikipedia.' in url:
                urltype = 'wikipedia'
            else:
                urltype = '-'

            yield Record(uid,'',ui + '\t' + day + '\t' + str(sess) + '\t' + q + '\t' + p + '\t' + urltype + '\t' + url + '\t' + req)
        prev = ts



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20160212', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20160213):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt = 'ensuetina/ENTO_TRAFFIC/data'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
